package org.nuiton.topia.templates;

/*
 * #%L
 * ToPIA :: Templates
 * $Id: TopiaStereoTypes.java 3144 2014-06-01 10:55:33Z tchemit $
 * $HeadURL: https://svn.nuiton.org/topia/tags/topia-3.0-beta-6/topia-templates/src/main/java/org/nuiton/topia/templates/TopiaStereoTypes.java $
 * %%
 * Copyright (C) 2004 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.stereotype.StereotypeDefinition;
import org.nuiton.eugene.models.stereotype.StereotypeDefinitionProvider;

/**
 * All extra stereotypes usable in topia generators.
 *
 * @author tchemit <chemit@codelutin.com>
 * @plexus.component role="org.nuiton.eugene.models.stereotype.StereotypeDefinitionProvider" role-hint="topia-templates"
 * @since 2.5
 */
public class TopiaStereoTypes extends StereotypeDefinitionProvider {

    /**
     * Stéréotype pour les objets devant être générées sous forme d'entités
     *
     * @see TopiaGeneratorUtil#isEntity(ObjectModelClassifier)
     * @see #hasEntityStereotype(ObjectModelAttribute)
     */
    @StereotypeDefinition(target = {ObjectModelClassifier.class, ObjectModelAttribute.class},
                          documentation = "To specify that a class is an Entity")
    public static final String STEREOTYPE_ENTITY = "entity";

    /**
     * Stéréotype pour les objets devant être générées sous forme de DTO.
     *
     * @see #hasDtoStereotype(ObjectModelClassifier)
     */
    @StereotypeDefinition(target = ObjectModelClassifier.class,
                          documentation = "to specify that a class is a DTO")
    public static final String STEREOTYPE_DTO = "dto";

    /**
     * Stéréotype pour les interfaces devant être générées sous forme de DAO.
     *
     * @see #hasDaoStereotype(ObjectModelClassifier)
     * @see #hasDaoStereotype(ObjectModelOperation)
     */
    @StereotypeDefinition(target = {ObjectModelClassifier.class, ObjectModelOperation.class},
                          documentation = "To Specify that a classifier or an operation should be generated as (or in) a DAO")
    public static final String STEREOTYPE_DAO = "dao";

    /**
     * Stéréotype pour les attributs étant des clés primaires.
     *
     * @see #hasPrimaryKeyStereotype(ObjectModelAttribute)
     * @deprecated since 3.0, use nowhere in ToPIA
     */
    @Deprecated
    @StereotypeDefinition(target = ObjectModelAttribute.class,
                          documentation = "To specify that an attribute is part of a primary key (Hibernate mapping)")
    public static final String STEREOTYPE_PRIMARY_KEY = "primaryKey";

    /**
     * Check if the given classifier has the {@link TopiaStereoTypes#STEREOTYPE_ENTITY} stereotype.
     *
     * @param classifier classifier to test
     * @return {@code true} if stereotype was found, {@code false otherwise}
     * @see TopiaStereoTypes#STEREOTYPE_ENTITY
     * @since 2.5
     */
    public static boolean hasEntityStereotype(ObjectModelClassifier classifier) {
        return classifier.hasStereotype(TopiaStereoTypes.STEREOTYPE_ENTITY);
    }

    /**
     * Check if the given attribute has the {@link TopiaStereoTypes#STEREOTYPE_ENTITY} stereotype.
     *
     * @param attribute attribute to test
     * @return {@code true} if stereotype was found, {@code false otherwise}
     * @see TopiaStereoTypes#STEREOTYPE_ENTITY
     * @since 2.5
     */
    public static boolean hasEntityStereotype(ObjectModelAttribute attribute) {
        return attribute.hasStereotype(TopiaStereoTypes.STEREOTYPE_ENTITY);
    }

    /**
     * Check if the given classifier has the {@link TopiaStereoTypes#STEREOTYPE_DTO} stereotype.
     *
     * @param classifier classifier to test
     * @return {@code true} if stereotype was found, {@code false otherwise}
     * @see TopiaStereoTypes#STEREOTYPE_DTO
     * @since 2.5
     */
    public static boolean hasDtoStereotype(ObjectModelClassifier classifier) {
        return classifier.hasStereotype(TopiaStereoTypes.STEREOTYPE_DTO);
    }

    /**
     * Check if the given classifier has the {@link TopiaStereoTypes#STEREOTYPE_DAO} stereotype.
     *
     * @param classifier classifier to test
     * @return {@code true} if stereotype was found, {@code false otherwise}
     * @see TopiaStereoTypes#STEREOTYPE_DAO
     * @since 2.5
     */
    public static boolean hasDaoStereotype(ObjectModelClassifier classifier) {
        return classifier.hasStereotype(TopiaStereoTypes.STEREOTYPE_DAO);
    }

    /**
     * Check if the given operation has the {@link TopiaStereoTypes#STEREOTYPE_DAO} stereotype.
     *
     * @param operation operation to test
     * @return {@code true} if stereotype was found, {@code false otherwise}
     * @see TopiaStereoTypes#STEREOTYPE_DAO
     * @since 2.5
     */
    public static boolean hasDaoStereotype(ObjectModelOperation operation) {
        return operation.hasStereotype(TopiaStereoTypes.STEREOTYPE_DAO);
    }

    /**
     * Check if the given attribute has the {@link TopiaStereoTypes#STEREOTYPE_PRIMARY_KEY} stereotype.
     *
     * @param attribute attribute to test
     * @return {@code true} if stereotype was found, {@code false otherwise}
     * @see TopiaStereoTypes#STEREOTYPE_PRIMARY_KEY
     * @since 2.5
     * @deprecated since 3.0, not used in ToPIA
     */
    @Deprecated
    public static boolean hasPrimaryKeyStereotype(ObjectModelAttribute attribute) {
        return attribute.hasStereotype(TopiaStereoTypes.STEREOTYPE_PRIMARY_KEY);
    }
}
