package org.nuiton.topia.templates;

/*
 * #%L
 * ToPIA :: Templates
 * $Id: ApplicationContextTransformer.java 2897 2013-11-27 11:11:51Z athimel $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-3.0-alpha-6/topia-templates/src/main/java/org/nuiton/topia/templates/ApplicationContextTransformer.java $
 * %%
 * Copyright (C) 2004 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */





import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.topia.AbstractTopiaApplicationContext;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.EntityOperator;
import org.nuiton.topia.persistence.util.EntityOperatorStore;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Properties;

/**
 * To generate PersistenceHelper
 *
 * @author tchemit <chemit@codelutin.com>
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.topia.templates.ApplicationContextTransformer"
 * @since 3.0
 */
public class ApplicationContextTransformer extends ObjectModelTransformerToJava {

    @Override
    public void transformFromModel(ObjectModel input) {

        String packageName = TopiaGeneratorUtil.getApplicationContextPackage(this, model);

        String applicationContextAbstractName = TopiaGeneratorUtil.getApplicationContextAbstractName(model);

        String applicationContextConcreteName = TopiaGeneratorUtil.getApplicationContextConcreteName(model);

        boolean generateAbstract = !isInClassPath(packageName, applicationContextAbstractName);

        boolean generateConcrete = !isInClassPath(packageName, applicationContextConcreteName);


        if (generateAbstract) {

            generateAbstract(packageName,
                             applicationContextAbstractName);
        }

        if (generateConcrete) {

            generateImpl(packageName,
                         applicationContextAbstractName,
                         applicationContextConcreteName);
        }

    }

    protected void generateAbstract(String packageName,
                                    String className) {

        // try to find a super class by tag-value
//        String superClass = TopiaGeneratorUtil.getPersistenceContextSuperClassTagValue(model);
        String superClass = null;

        if (superClass == null) {

            // no super-class, use default one
            superClass = AbstractTopiaApplicationContext.class.getName();
        }

        ObjectModelClass output = createAbstractClass(className, packageName);

        String persistenceContextConcreteName = TopiaGeneratorUtil.getPersistenceContextConcreteName(model);
        setSuperClass(output, superClass + "<" + persistenceContextConcreteName + ">");

        // detect if there is a contract to set on abstract
        String contractName = TopiaGeneratorUtil.getPersistenceContextInterfaceName(model);

//        addInterface(output, TopiaPersistenceContext.class);

        boolean addPersistenceContextContract = isInClassPath(packageName, contractName);

        if (addPersistenceContextContract) {
            addInterface(output, packageName + "." + contractName);
        }

        String modelName = model.getName();
        String daoHelperClazzName = modelName + "DAOHelper";

        String entityEnumName = modelName + "EntityEnum";

        List<ObjectModelClass> entityClasses =
                TopiaGeneratorUtil.getEntityClasses(model, true);

        boolean generateOperator =
                TopiaGeneratorUtil.shouldGenerateOperatorForDAOHelper(model);

//        boolean generateStandaloneEnum =
//                TopiaGeneratorUtil.shouldGenerateStandaloneEnumForDAOHelper(model);
//
//        if (!generateStandaloneEnum) {
//
//            addImport(output, packageName + "." + daoHelperClazzName + "." + entityEnumName);
//
//        }

        addImport(output, TopiaEntity.class);
        addImport(output, Array.class);
        addImport(output, Array.class);

        if (generateOperator) {
            addImport(output, EntityOperator.class);
            addImport(output, EntityOperatorStore.class);
        }

        // add public constructor
        ObjectModelOperation constructor = addConstructor(
                output,
                ObjectModelJavaModifier.PUBLIC);
        addParameter(constructor, Properties.class, "properties");
        setOperationBody(constructor, ""
+"\n"
+"        super(properties);\n"
+"    "
        );

        constructor = addConstructor(
                output,
                ObjectModelJavaModifier.PUBLIC);
        addParameter(constructor, "java.util.Map<String, String>", "configuration");
        setOperationBody(constructor, ""
+"\n"
+"        super(configuration);\n"
+"    "
        );

        ObjectModelOperation op;

        // getModelVersion method
        op = addOperation(output, "newPersistenceContext", persistenceContextConcreteName, ObjectModelJavaModifier.PUBLIC);
        addAnnotation(output, op, Override.class);
        setOperationBody(op, ""
+"\n"
+"        "+persistenceContextConcreteName+" newContext = new "+persistenceContextConcreteName+"(\n"
+"                getHibernateProvider(), getTopiaListenableSupport(), getTopiaIdFactory(), getSessionRegistry());\n"
+"        registerPersistenceContext(newContext);\n"
+"        return newContext;\n"
+"    "
        );

        // getModelVersion method
        String modelVersion = model.getVersion();
        op = addOperation(output, "getModelVersion", "String", ObjectModelJavaModifier.PUBLIC);
        setOperationBody(op, ""
+"\n"
+"        return \""+modelVersion+"\";\n"
+"    "
        );

        // getModelName method
        op = addOperation(output, "getModelName", "String", ObjectModelJavaModifier.PUBLIC);
        setOperationBody(op, ""
+"\n"
+"        return \""+modelName+"\";\n"
+"    "
        );

        // getContractClass method
        op = addOperation(output, "getContractClass", "<T extends TopiaEntity> Class<T>", ObjectModelJavaModifier.PUBLIC);
        addParameter(op, "Class<T>", "klass");
        setOperationBody(op, ""
+"\n"
+"        "+entityEnumName+" constant = "+entityEnumName+".valueOf(klass);\n"
+"        return (Class<T>) constant.getContract();\n"
+"    "
        );

        // getImplementationClass method
        op = addOperation(output, "getImplementationClass", "<T extends TopiaEntity> Class<T>", ObjectModelJavaModifier.PUBLIC);
        addParameter(op, "Class<T>", "klass");
        setOperationBody(op, ""
+"\n"
+"        "+entityEnumName+" constant = "+entityEnumName+".valueOf(klass);\n"
+"        return (Class<T>) constant.getImplementation();\n"
+"    "
        );

        // getContractClasses method
        op = addOperation(output, "getContractClasses", "Class<? extends TopiaEntity>[]", ObjectModelJavaModifier.PUBLIC);
        setOperationBody(op, ""
+"\n"
+"        "+entityEnumName+"[] values = "+entityEnumName+".values();\n"
+"        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);\n"
+"        for (int i = 0; i < values.length; i++) {\n"
+"            result[i] = values[i].getContract();\n"
+"        }\n"
+"        return result;\n"
+"    "
        );

        // getImplementationClasses method
        op = addOperation(output, "getImplementationClasses", "Class<? extends TopiaEntity>[]", ObjectModelJavaModifier.PUBLIC);
        setOperationBody(op, ""
+"\n"
+"        "+entityEnumName+"[] values = "+entityEnumName+".values();\n"
+"        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);\n"
+"        for (int i = 0; i < values.length; i++) {\n"
+"            result[i] = values[i].getImplementation();\n"
+"        }\n"
+"        return result;\n"
+"    "
        );

        // getContracts method
        op = addOperation(output, "getContracts", entityEnumName + "[]", ObjectModelJavaModifier.PUBLIC);
        setOperationBody(op, ""
+"\n"
+"        return "+entityEnumName+".values();\n"
+"    "
        );

        if (generateOperator) {
            // getOperator method
            op = addOperation(output, "getOperator", "<T extends TopiaEntity> EntityOperator<T>", ObjectModelJavaModifier.PUBLIC);
            addParameter(op, "Class<T>", "klass");
            setOperationBody(op, ""
+"\n"
+"        "+entityEnumName+" constant = "+entityEnumName+".valueOf(klass);\n"
+"        return EntityOperatorStore.getOperator(constant);\n"
+"    "
            );
        }

    }

    protected ObjectModelClass generateImpl(String packageName,
                                            String applicationContextAbstractName,
                                            String applicationContextConcreteName) {

        ObjectModelClass output = createClass(applicationContextConcreteName, packageName);

        setSuperClass(output, applicationContextAbstractName);

        // add public constructor
        ObjectModelOperation constructor = addConstructor(
                output,
                ObjectModelJavaModifier.PUBLIC);
        addParameter(constructor, Properties.class, "properties");
        setOperationBody(constructor, ""
+"\n"
+"        super(properties);\n"
+"    "
        );

        constructor = addConstructor(
                output,
                ObjectModelJavaModifier.PUBLIC);
        addParameter(constructor, "java.util.Map<String, String>", "configuration");
        setOperationBody(constructor, ""
+"\n"
+"        super(configuration);\n"
+"    "
        );

        return output;
    }

}
