package org.nuiton.topia.taas.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.generator.EntityTransformer", date = "Fri Apr 17 10:02:34 UTC 2015")
public abstract class TaasUserAbstract extends TopiaEntityAbstract implements TaasUser {

    /**
     * Nom de l'attribut en BD : login
     */
    protected String login;

    /**
     * Nom de l'attribut en BD : password
     */
    protected String password;

    /**
     * Nom de l'attribut en BD : email
     */
    protected String email;

    /**
     * Nom de l'attribut en BD : enabled
     */
    protected boolean enabled;

    /**
     * Nom de l'attribut en BD : lastConnectionDate
     */
    protected Date lastConnectionDate;

    /**
     * Nom de l'attribut en BD : numberOfConnection
     */
    protected int numberOfConnection;

    /**
     * Nom de l'attribut en BD : link
     */
    protected String link;

    /**
     * Nom de l'attribut en BD : principals
     */
    protected Collection<TaasPrincipal> principals;

    private static final long serialVersionUID = 3691037660360630576L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(EntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_LOGIN, String.class, login);
        visitor.visit(this, PROPERTY_PASSWORD, String.class, password);
        visitor.visit(this, PROPERTY_EMAIL, String.class, email);
        visitor.visit(this, PROPERTY_ENABLED, boolean.class, enabled);
        visitor.visit(this, PROPERTY_LAST_CONNECTION_DATE, Date.class, lastConnectionDate);
        visitor.visit(this, PROPERTY_NUMBER_OF_CONNECTION, int.class, numberOfConnection);
        visitor.visit(this, PROPERTY_LINK, String.class, link);
        visitor.visit(this, PROPERTY_PRINCIPALS, Collection.class, TaasPrincipal.class, principals);
    }

    @Override
    public void setLogin(String login) {
        String oldValue = this.login;
        fireOnPreWrite(PROPERTY_LOGIN, oldValue, login);
        this.login = login;
        fireOnPostWrite(PROPERTY_LOGIN, oldValue, login);
    }

    @Override
    public String getLogin() {
        fireOnPreRead(PROPERTY_LOGIN, login);

        String result = this.login;

        fireOnPostRead(PROPERTY_LOGIN, login);

        return result;
    }

    @Override
    public void setPassword(String password) {
        String oldValue = this.password;
        fireOnPreWrite(PROPERTY_PASSWORD, oldValue, password);
        this.password = password;
        fireOnPostWrite(PROPERTY_PASSWORD, oldValue, password);
    }

    @Override
    public String getPassword() {
        fireOnPreRead(PROPERTY_PASSWORD, password);

        String result = this.password;

        fireOnPostRead(PROPERTY_PASSWORD, password);

        return result;
    }

    @Override
    public void setEmail(String email) {
        String oldValue = this.email;
        fireOnPreWrite(PROPERTY_EMAIL, oldValue, email);
        this.email = email;
        fireOnPostWrite(PROPERTY_EMAIL, oldValue, email);
    }

    @Override
    public String getEmail() {
        fireOnPreRead(PROPERTY_EMAIL, email);

        String result = this.email;

        fireOnPostRead(PROPERTY_EMAIL, email);

        return result;
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean oldValue = this.enabled;
        fireOnPreWrite(PROPERTY_ENABLED, oldValue, enabled);
        this.enabled = enabled;
        fireOnPostWrite(PROPERTY_ENABLED, oldValue, enabled);
    }

    @Override
    public boolean isEnabled() {
        fireOnPreRead(PROPERTY_ENABLED, enabled);

        boolean result = this.enabled;

        fireOnPostRead(PROPERTY_ENABLED, enabled);

        return result;
    }

    @Override
    public void setLastConnectionDate(Date lastConnectionDate) {
        Date oldValue = this.lastConnectionDate;
        fireOnPreWrite(PROPERTY_LAST_CONNECTION_DATE, oldValue, lastConnectionDate);
        this.lastConnectionDate = lastConnectionDate;
        fireOnPostWrite(PROPERTY_LAST_CONNECTION_DATE, oldValue, lastConnectionDate);
    }

    @Override
    public Date getLastConnectionDate() {
        fireOnPreRead(PROPERTY_LAST_CONNECTION_DATE, lastConnectionDate);

        Date result = this.lastConnectionDate;

        fireOnPostRead(PROPERTY_LAST_CONNECTION_DATE, lastConnectionDate);

        return result;
    }

    @Override
    public void setNumberOfConnection(int numberOfConnection) {
        int oldValue = this.numberOfConnection;
        fireOnPreWrite(PROPERTY_NUMBER_OF_CONNECTION, oldValue, numberOfConnection);
        this.numberOfConnection = numberOfConnection;
        fireOnPostWrite(PROPERTY_NUMBER_OF_CONNECTION, oldValue, numberOfConnection);
    }

    @Override
    public int getNumberOfConnection() {
        fireOnPreRead(PROPERTY_NUMBER_OF_CONNECTION, numberOfConnection);

        int result = this.numberOfConnection;

        fireOnPostRead(PROPERTY_NUMBER_OF_CONNECTION, numberOfConnection);

        return result;
    }

    @Override
    public void setLink(String link) {
        String oldValue = this.link;
        fireOnPreWrite(PROPERTY_LINK, oldValue, link);
        this.link = link;
        fireOnPostWrite(PROPERTY_LINK, oldValue, link);
    }

    @Override
    public String getLink() {
        fireOnPreRead(PROPERTY_LINK, link);

        String result = this.link;

        fireOnPostRead(PROPERTY_LINK, link);

        return result;
    }

    @Override
    public void addPrincipals(TaasPrincipal principals) {
        fireOnPreWrite(PROPERTY_PRINCIPALS, null, principals);
        if (this.principals == null) {
            this.principals = new ArrayList<TaasPrincipal>();
        }

        this.principals.add(principals);
        fireOnPostWrite(PROPERTY_PRINCIPALS, this.principals.size(), null, principals);
    }

    @Override
    public void addAllPrincipals(Collection<TaasPrincipal> principals) {
        if (principals == null) {
            return;
        }
        for (TaasPrincipal item : principals) {
            addPrincipals(item);
        }
    }

    @Override
    public void setPrincipals(Collection<TaasPrincipal> principals) {
        // Copy elements to keep data for fire with new reference
        Collection<TaasPrincipal> oldValue = this.principals != null ? new ArrayList<TaasPrincipal>(this.principals) : null;
        fireOnPreWrite(PROPERTY_PRINCIPALS, oldValue, principals);
        this.principals = principals;
        fireOnPostWrite(PROPERTY_PRINCIPALS, oldValue, principals);
    }

    @Override
    public void removePrincipals(TaasPrincipal principals) {
        fireOnPreWrite(PROPERTY_PRINCIPALS, principals, null);
        if (this.principals == null || !this.principals.remove(principals)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_PRINCIPALS, this.principals.size() + 1, principals, null);
    }

    @Override
    public void clearPrincipals() {
        if (this.principals == null) {
            return;
        }
        Collection<TaasPrincipal> oldValue = new ArrayList<TaasPrincipal>(this.principals);
        fireOnPreWrite(PROPERTY_PRINCIPALS, oldValue, this.principals);
        this.principals.clear();
        fireOnPostWrite(PROPERTY_PRINCIPALS, oldValue, this.principals);
    }

    @Override
    public Collection<TaasPrincipal> getPrincipals() {
        return principals;
    }

    @Override
    public TaasPrincipal getPrincipalsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(principals, topiaId);
    }

    @Override
    public int sizePrincipals() {
        if (principals == null) {
            return 0;
        }
        return principals.size();
    }

    @Override
    public boolean isPrincipalsEmpty() {
        int size = sizePrincipals();
        return size == 0;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_LOGIN, this.login).
            append(PROPERTY_PASSWORD, this.password).
            append(PROPERTY_EMAIL, this.email).
            append(PROPERTY_ENABLED, this.enabled).
            append(PROPERTY_LAST_CONNECTION_DATE, this.lastConnectionDate).
            append(PROPERTY_NUMBER_OF_CONNECTION, this.numberOfConnection).
            append(PROPERTY_LINK, this.link).
            append(PROPERTY_PRINCIPALS, this.principals).
         toString();
        return result;
    }

} //TaasUserAbstract
