package org.nuiton.topia.taas.entities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public  abstract class TaasAuthorizationDAOAbstract<E extends TaasAuthorization> extends TopiaDAOImpl<E> implements TopiaDAO<E> {


     /**
      * getEntityClass :
      * @return Class<E> 
      */
    public Class<E> getEntityClass() {
        return (Class<E>)TaasAuthorization.class;
    }

     /**
      * delete :
      * @param entity 
      * @throws TopiaException
      */
    public void delete(E entity) throws TopiaException {
        {
            List<TaasPrincipal> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from taasPrincipal main, authorizations_principals secondary " +
                    "where main.topiaid=secondary.principals" +
                    " and secondary.authorizations='" + entity.getTopiaId() + "'")
                    .addEntity("main", org.nuiton.topia.TopiaSecurityDAOHelper.getImplementationClass(TaasPrincipal.class)).list();

            for (TaasPrincipal item : list) {
                item.removeAuthorizations(entity);
            }
        }

        super.delete(entity);
    }

     /**
      * findByExpression :
      * Retourne le premier élément trouvé ayant comme valeur pour l'attribut expression le paramètre.
      * @param v 
      * @return E 
      * @throws TopiaException
      */
    public E findByExpression(String v) throws TopiaException {
        E result = findByProperty(TaasAuthorization.EXPRESSION, v);
        return result;
    }

     /**
      * findAllByExpression :
      * Retourne les éléments ayant comme valeur pour l'attribut expression le paramètre.
      * @param v 
      * @return List<E> 
      * @throws TopiaException
      */
    public List<E> findAllByExpression(String v) throws TopiaException {
        List<E> result = findAllByProperty(TaasAuthorization.EXPRESSION, v);
        return result;
    }

     /**
      * findByActions :
      * Retourne le premier élément trouvé ayant comme valeur pour l'attribut actions le paramètre.
      * @param v 
      * @return E 
      * @throws TopiaException
      */
    public E findByActions(int v) throws TopiaException {
        E result = findByProperty(TaasAuthorization.ACTIONS, v);
        return result;
    }

     /**
      * findAllByActions :
      * Retourne les éléments ayant comme valeur pour l'attribut actions le paramètre.
      * @param v 
      * @return List<E> 
      * @throws TopiaException
      */
    public List<E> findAllByActions(int v) throws TopiaException {
        List<E> result = findAllByProperty(TaasAuthorization.ACTIONS, v);
        return result;
    }

     /**
      * findUsages :
      * @param type 
      * @param entity 
      * @return <U extends TopiaEntity> List<U> 
      * @throws TopiaException
      */

    @Override    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == TaasPrincipal.class) {
            TaasPrincipalDAO dao = (TaasPrincipalDAO)
                getContext().getDAO(TaasPrincipal.class);
            tmp = dao.findAllContainsAuthorizations(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

     /**
      * findAllUsages :
      * @param entity 
      * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
      * @throws TopiaException
      */

    @Override    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(TaasPrincipal.class, entity);
        if (!list.isEmpty()) {
            result.put(TaasPrincipal.class, list);
        }

        return result;
    }


} //TaasAuthorizationDAOAbstract<E extends TaasAuthorization>
