package org.nuiton.topia.taas.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;


public  abstract class TaasPrincipalAbstract extends TopiaEntityAbstract implements TaasPrincipal {

    protected String name;
    protected Collection<TaasAuthorization> authorizations;
    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, NAME, String.class, name);
        visitor.visit(this, AUTHORIZATIONS, Collection.class, TaasAuthorization.class, authorizations);
        visitor.end(this);
}

    /**
     * setName :
     * @param name 
     */

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(NAME, oldValue, name);
}

    /**
     * getName :
     * @return String 
     */

    @Override
    public String getName() {
        fireOnPreRead(NAME, name);
        String result = this.name;
        fireOnPostRead(NAME, name);
        return result;
}

    /**
     * addAuthorizations :
     * @param authorizations 
     */

    @Override
    public void addAuthorizations(TaasAuthorization authorizations) {
        fireOnPreWrite(AUTHORIZATIONS, null, authorizations);
        if (this.authorizations == null) {
            this.authorizations = new ArrayList<TaasAuthorization>();
        }

        this.authorizations.add(authorizations);
        fireOnPostWrite(AUTHORIZATIONS, this.authorizations.size(), null, authorizations);
}

    /**
     * addAllAuthorizations :
     * @param authorizations 
     */

    @Override
    public void addAllAuthorizations(Collection<TaasAuthorization> authorizations) {
        if (authorizations == null) {
            return;
        }
        for (TaasAuthorization item : authorizations) {
            addAuthorizations(item);
        }
}

    /**
     * setAuthorizations :
     * @param authorizations 
     */

    @Override
    public void setAuthorizations(Collection<TaasAuthorization> authorizations) {
        // Copy elements to keep data for fire with new reference
        Collection<TaasAuthorization> oldValue = this.authorizations != null ? new ArrayList<TaasAuthorization>(this.authorizations) : null;
        fireOnPreWrite(AUTHORIZATIONS, oldValue, authorizations);
        this.authorizations = authorizations;
        fireOnPostWrite(AUTHORIZATIONS, oldValue, authorizations);
}

    /**
     * removeAuthorizations :
     * @param authorizations 
     */

    @Override
    public void removeAuthorizations(TaasAuthorization authorizations) {
        fireOnPreWrite(AUTHORIZATIONS, authorizations, null);
        if ((this.authorizations == null) || (!this.authorizations.remove(authorizations))) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(AUTHORIZATIONS, this.authorizations.size() + 1, authorizations, null);
}

    /**
     * clearAuthorizations :
     */

    @Override
    public void clearAuthorizations() {
        if (this.authorizations == null) {
            return;
        }
        Collection<TaasAuthorization> oldValue = new ArrayList<TaasAuthorization>(this.authorizations);
        fireOnPreWrite(AUTHORIZATIONS, oldValue, this.authorizations);
        this.authorizations.clear();
        fireOnPostWrite(AUTHORIZATIONS, oldValue, this.authorizations);
}

    /**
     * getAuthorizations :
     * @return Collection<TaasAuthorization> 
     */

    @Override
    public Collection<TaasAuthorization> getAuthorizations() {
        return authorizations;
}

    /**
     * getAuthorizationsByTopiaId :
     * @param topiaId 
     * @return TaasAuthorization 
     */

    @Override
    public TaasAuthorization getAuthorizationsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(authorizations, topiaId);
 }

    /**
     * sizeAuthorizations :
     * @return int 
     */

    @Override
    public int sizeAuthorizations() {
        if (authorizations == null) {
            return 0;
        }
        return authorizations.size();
}

    /**
     * isAuthorizationsEmpty :
     * @return boolean 
     */

    @Override
    public boolean isAuthorizationsEmpty() {
        int size = sizeAuthorizations();
        return size == 0;
}

    /**
     * getAggregate :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
    }

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(NAME, this.name).
            append(AUTHORIZATIONS, this.authorizations).
         toString();
        return result;
}


} //TaasPrincipalAbstract
