package org.nuiton.topia.security.entities.authorization;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;


public  abstract class TopiaAssociationAuthorizationAbstract extends TopiaAuthorizationImpl implements TopiaAssociationAuthorization {

    protected String idBeginAssociation;
    protected String nameAssociation;
    protected int actions;
    protected Set principals;
    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, ID_BEGIN_ASSOCIATION, String.class, idBeginAssociation);
        visitor.visit(this, NAME_ASSOCIATION, String.class, nameAssociation);
        visitor.visit(this, ACTIONS, int.class, actions);
        visitor.visit(this, PRINCIPALS, Set.class, principals);
        visitor.end(this);
}

    /**
     * setIdBeginAssociation :
     * @param idBeginAssociation 
     */

    @Override
    public void setIdBeginAssociation(String idBeginAssociation) {
        String oldValue = this.idBeginAssociation;
        fireOnPreWrite(ID_BEGIN_ASSOCIATION, oldValue, idBeginAssociation);
        this.idBeginAssociation = idBeginAssociation;
        fireOnPostWrite(ID_BEGIN_ASSOCIATION, oldValue, idBeginAssociation);
}

    /**
     * getIdBeginAssociation :
     * @return String 
     */

    @Override
    public String getIdBeginAssociation() {
        fireOnPreRead(ID_BEGIN_ASSOCIATION, idBeginAssociation);
        String result = this.idBeginAssociation;
        fireOnPostRead(ID_BEGIN_ASSOCIATION, idBeginAssociation);
        return result;
}

    /**
     * setNameAssociation :
     * @param nameAssociation 
     */

    @Override
    public void setNameAssociation(String nameAssociation) {
        String oldValue = this.nameAssociation;
        fireOnPreWrite(NAME_ASSOCIATION, oldValue, nameAssociation);
        this.nameAssociation = nameAssociation;
        fireOnPostWrite(NAME_ASSOCIATION, oldValue, nameAssociation);
}

    /**
     * getNameAssociation :
     * @return String 
     */

    @Override
    public String getNameAssociation() {
        fireOnPreRead(NAME_ASSOCIATION, nameAssociation);
        String result = this.nameAssociation;
        fireOnPostRead(NAME_ASSOCIATION, nameAssociation);
        return result;
}

    /**
     * setActions :
     * @param actions 
     */

    @Override
    public void setActions(int actions) {
        int oldValue = this.actions;
        fireOnPreWrite(ACTIONS, oldValue, actions);
        this.actions = actions;
        fireOnPostWrite(ACTIONS, oldValue, actions);
}

    /**
     * getActions :
     * @return int 
     */

    @Override
    public int getActions() {
        fireOnPreRead(ACTIONS, actions);
        int result = this.actions;
        fireOnPostRead(ACTIONS, actions);
        return result;
}

    /**
     * setPrincipals :
     * @param principals 
     */

    @Override
    public void setPrincipals(Set principals) {
        Set oldValue = this.principals;
        fireOnPreWrite(PRINCIPALS, oldValue, principals);
        this.principals = principals;
        fireOnPostWrite(PRINCIPALS, oldValue, principals);
}

    /**
     * getPrincipals :
     * @return Set 
     */

    @Override
    public Set getPrincipals() {
        fireOnPreRead(PRINCIPALS, principals);
        Set result = this.principals;
        fireOnPostRead(PRINCIPALS, principals);
        return result;
}

    /**
     * getAggregate :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
    }

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(ID_BEGIN_ASSOCIATION, this.idBeginAssociation).
            append(NAME_ASSOCIATION, this.nameAssociation).
            append(ACTIONS, this.actions).
            append(PRINCIPALS, this.principals).
         toString();
        return result;
}


} //TopiaAssociationAuthorizationAbstract
