package org.nuiton.topia.taas.entities;

import java.util.Collection;
import java.util.Date;
import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

@SearchFields (
  txtFields={TaasUser.LOGIN, TaasUser.PASSWORD, TaasUser.EMAIL, TaasUser.LINK},
  numFields={TaasUser.NUMBER_OF_CONNECTION},
  boolFields={TaasUser.ENABLED},
  dateFields={TaasUser.LAST_CONNECTION_DATE}
)

public interface TaasUser extends TopiaEntity {     String LOGIN = "login";
     String PASSWORD = "password";
     String EMAIL = "email";
     String ENABLED = "enabled";
     String LAST_CONNECTION_DATE = "lastConnectionDate";
     String NUMBER_OF_CONNECTION = "numberOfConnection";
     String LINK = "link";
     String PRINCIPALS = "principals";
    /**
     * setLogin :
     * @param login La valeur de l'attribut login à positionner.
     */

     void setLogin(String login);

    /**
     * getLogin :
     * @return String 
     */

     String getLogin();

    /**
     * setPassword :
     * @param password La valeur de l'attribut password à positionner.
     */

     void setPassword(String password);

    /**
     * getPassword :
     * @return String 
     */

     String getPassword();

    /**
     * setEmail :
     * @param email La valeur de l'attribut email à positionner.
     */

     void setEmail(String email);

    /**
     * getEmail :
     * @return String 
     */

     String getEmail();

    /**
     * setEnabled :
     * @param enabled La valeur de l'attribut enabled à positionner.
     */

     void setEnabled(boolean enabled);

    /**
     * getEnabled :
     * @return boolean 
     */

     boolean getEnabled();

    /**
     * setLastConnectionDate :
     * @param lastConnectionDate La valeur de l'attribut lastConnectionDate à positionner.
     */

     void setLastConnectionDate(Date lastConnectionDate);

    /**
     * getLastConnectionDate :
     * @return Date 
     */

     Date getLastConnectionDate();

    /**
     * setNumberOfConnection :
     * @param numberOfConnection La valeur de l'attribut numberOfConnection à positionner.
     */

     void setNumberOfConnection(int numberOfConnection);

    /**
     * getNumberOfConnection :
     * @return int 
     */

     int getNumberOfConnection();

    /**
     * setLink :
     * @param link La valeur de l'attribut link à positionner.
     */

     void setLink(String link);

    /**
     * getLink :
     * @return String 
     */

     String getLink();

    /**
     * addPrincipals :
     * @param principals L'instance de principals à ajouter
     */

     void addPrincipals(TaasPrincipal principals);

    /**
     * addAllPrincipals :
     * @param principals Les instances de principals à ajouter
     */

     void addAllPrincipals(Collection<TaasPrincipal> principals);

    /**
     * setPrincipals :
     * @param principals La Collection de principals à ajouter
     */

     void setPrincipals(Collection<TaasPrincipal> principals);

    /**
     * removePrincipals :
     * @param principals Vide la Collection de principals
     */

     void removePrincipals(TaasPrincipal principals);

    /**
     * clearPrincipals :
     */

     void clearPrincipals();

    /**
     * getPrincipals :
     * @return Collection<TaasPrincipal> 
     */

     Collection<TaasPrincipal> getPrincipals();

    /**
     * getPrincipalsByTopiaId :
     * Recupère l'attribut principals à partir de son topiaId
     * @param topiaId le topia id de l'entité recherchée
     * @return TaasPrincipal 
     */

     TaasPrincipal getPrincipalsByTopiaId(String topiaId);

    /**
     * sizePrincipals :
     * Retourne le nombre d'éléments de la collection principals
     * @return int 
     */

     int sizePrincipals();

    /**
     * isPrincipalsEmpty :
     * Retourne {@code true} si la collection principals est vide.
     * @return boolean 
     */

     boolean isPrincipalsEmpty();


} //TaasUser
