package org.nuiton.topia.security.entities.authorization;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class TopiaEntityAuthorizationAbstract extends TopiaAuthorizationImpl implements TopiaEntityAuthorization {

    protected String expression;
    protected int actions;
    protected Set principals;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TopiaEntityAuthorization.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TopiaEntityAuthorization.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, EXPRESSION, String.class, expression);
        visitor.visit(this, ACTIONS, int.class, actions);
        visitor.visit(this, PRINCIPALS, Set.class, principals);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setExpression :
     * @param value 
     */

    public void setExpression(String value) {
        String _oldValue = this.expression;
        fireOnPreWrite(EXPRESSION, _oldValue, value);
        this.expression = value;
        fireOnPostWrite(EXPRESSION, _oldValue, value);
}

    /**
     * getExpression :
     * @return String 
     */

    public String getExpression() {
        fireOnPreRead(EXPRESSION, expression);
        String result = this.expression;
        fireOnPostRead(EXPRESSION, expression);
        return result;
}

    /**
     * setActions :
     * @param value 
     */

    public void setActions(int value) {
        int _oldValue = this.actions;
        fireOnPreWrite(ACTIONS, _oldValue, value);
        this.actions = value;
        fireOnPostWrite(ACTIONS, _oldValue, value);
}

    /**
     * getActions :
     * @return int 
     */

    public int getActions() {
        fireOnPreRead(ACTIONS, actions);
        int result = this.actions;
        fireOnPostRead(ACTIONS, actions);
        return result;
}

    /**
     * setPrincipals :
     * @param value 
     */

    public void setPrincipals(Set value) {
        Set _oldValue = this.principals;
        fireOnPreWrite(PRINCIPALS, _oldValue, value);
        this.principals = value;
        fireOnPostWrite(PRINCIPALS, _oldValue, value);
}

    /**
     * getPrincipals :
     * @return Set 
     */

    public Set getPrincipals() {
        fireOnPreRead(PRINCIPALS, principals);
        Set result = this.principals;
        fireOnPostRead(PRINCIPALS, principals);
        return result;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(EXPRESSION, this.expression).
            append(ACTIONS, this.actions).
            append(PRINCIPALS, this.principals).
         toString();
        return result;
}


} //TopiaEntityAuthorizationAbstract
