package org.nuiton.topia.taas.entities;

import java.util.List;


import java.util.Arrays;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;

/**
 * Implantation DAO pour l'entité TaasPrincipal.
 * Cette classe contient une implantation de TopiaDAO a laquel elle peut
 * deleguer des traitements
 * 
 */
public abstract class TaasPrincipalDAOAbstract<E extends TaasPrincipal> extends org.nuiton.topia.persistence.TopiaDAOImpl<E> implements org.nuiton.topia.persistence.TopiaDAO<E> {    

    public Class<E> getEntityClass() {
        return (Class<E>)TaasPrincipal.class;
    }

    public void delete(E entity) throws TopiaException {

        {
            List<org.nuiton.topia.taas.entities.TaasUser> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from taasUser main, principals_users secondary " +
                    "where main.topiaid=secondary.users" +
                    " and secondary.principals='" + entity.getTopiaId() + "'")
                    .addEntity("main", org.nuiton.topia.TopiaSecurityDAOHelper.getImplementationClass(org.nuiton.topia.taas.entities.TaasUser.class)).list();
            for (org.nuiton.topia.taas.entities.TaasUser item : list) {
                item.removePrincipals(entity);
            }
        }
        
        super.delete(entity);
    }    
     
    /**
     * Recherche sur l'attribut name
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * name le paramètre
     * @param v la valeur que doit avoir name
     * @return un element ou null
     */
    public E findByName(java.lang.String v) throws TopiaException {
        E result = findByProperty("name", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * name le paramètre
     * @param v la valeur que doit avoir name
     * @return une liste
     */
    public List<E> findAllByName(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("name", v);
        return result;
    }
    /**
     * Recherche sur l'attribut authorizations
     */
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * authorizations contient le paramètre
     * @param v la valeur que doit contenir authorizations
     * @return un element ou null
     */
    public E findContainsAuthorizations(org.nuiton.topia.taas.entities.TaasAuthorization ... v) throws TopiaException {
        E result = findContainsProperties("authorizations", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * authorizations contient le paramètre
     * @param v la valeur que doit contenir authorizations
     * @return une liste
     */
    public List<E> findAllContainsAuthorizations(org.nuiton.topia.taas.entities.TaasAuthorization ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("authorizations", Arrays.asList(v));
        return results;
    }

} // TaasPrincipalDAOAbstract
