package org.nuiton.topia.it.mapping.test6;

/*-
 * #%L
 * ToPIA :: IT
 * %%
 * Copyright (C) 2004 - 2024 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.LinkedList;
import java.util.List;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class A61Abstract extends AbstractTopiaEntity implements A61 {

    /**
     * Nom de l'attribut en BD : roleB61
     */
    protected List<B61> roleB61;

    private static final long serialVersionUID = 3904956448734930534L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_ROLE_B61, List.class, B61.class, roleB61);
    }

    @Override
    public void addRoleB61(B61 roleB61) {
        fireOnPreWrite(PROPERTY_ROLE_B61, null, roleB61);
        if (this.roleB61 == null) {
            this.roleB61 = new LinkedList<B61>();
        }
        this.roleB61.add(roleB61);
        fireOnPostWrite(PROPERTY_ROLE_B61, this.roleB61.size(), null, roleB61);
    }

    @Override
    public void addRoleB61(int index, B61 roleB61) {
        fireOnPreWrite(PROPERTY_ROLE_B61, null, roleB61);
        if (this.roleB61 == null) {
            this.roleB61 = new LinkedList<B61>();
        }
        this.roleB61.add(index, roleB61);
        fireOnPostWrite(PROPERTY_ROLE_B61, index, null, roleB61);
    }

    @Override
    public void addAllRoleB61(Iterable<B61> roleB61) {
        if (roleB61 == null) {
            return;
        }
        for (B61 item : roleB61) {
            addRoleB61(item);
        }
    }

    @Override
    public void setRoleB61(List<B61> roleB61) {
        // Copy elements to keep data for fire with new reference
        List<B61> oldValue = this.roleB61 != null ? new LinkedList<B61>(this.roleB61) : null;
        fireOnPreWrite(PROPERTY_ROLE_B61, oldValue, roleB61);
        this.roleB61 = roleB61;
        fireOnPostWrite(PROPERTY_ROLE_B61, oldValue, roleB61);
    }

    @Override
    public void removeRoleB61(B61 roleB61) {
        fireOnPreWrite(PROPERTY_ROLE_B61, roleB61, null);
        if (this.roleB61 == null || !this.roleB61.remove(roleB61)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        fireOnPostWrite(PROPERTY_ROLE_B61, this.roleB61.size() + 1, roleB61, null);
    }

    @Override
    public void removeRoleB61(int index) {
        fireOnPreWrite(PROPERTY_ROLE_B61, roleB61, null);
        if (this.roleB61 == null) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        B61 oldValue = this.roleB61.remove(index);
        if (oldValue == null) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        fireOnPostWrite(PROPERTY_ROLE_B61, index, oldValue, null);
    }

    @Override
    public void clearRoleB61() {
        if (this.roleB61 == null) {
            return;
        }
        List<B61> oldValue = new LinkedList<B61>(this.roleB61);
        fireOnPreWrite(PROPERTY_ROLE_B61, oldValue, this.roleB61);
        this.roleB61.clear();
        fireOnPostWrite(PROPERTY_ROLE_B61, oldValue, this.roleB61);
    }

    @Override
    public List<B61> getRoleB61() {
        return roleB61;
    }

    @Override
    public B61 getRoleB61(int index) {
        return TopiaEntityHelper.getEntityByIndex(roleB61, index);
    }

    @Override
    public B61 getRoleB61ByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(roleB61, topiaId);
    }

    @Override
    public List<String> getRoleB61TopiaIds() {
        List<String> topiaIds = new LinkedList<String>();
        List<org.nuiton.topia.it.mapping.test6.B61> tmp = getRoleB61();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeRoleB61() {
        if (roleB61 == null) {
            return 0;
        }
        return roleB61.size();
    }

    @Override
    public boolean isRoleB61Empty() {
        int size = sizeRoleB61();
        return size == 0;
    }

    @Override
    public boolean isRoleB61NotEmpty() {
        boolean empty = isRoleB61Empty();
        return ! empty;
    }

    @Override
    public boolean containsRoleB61(B61 roleB61) {
        boolean contains = this.roleB61 !=null && this.roleB61.contains(roleB61);
        return contains;
    }

} //A61Abstract
