package org.nuiton.topia.it.legacy.topiatest;

/*-
 * #%L
 * ToPIA :: IT
 * %%
 * Copyright (C) 2004 - 2024 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;

public abstract class EmployeAbstract extends PersonneImpl implements Employe {

    /**
     * Nom de l'attribut en BD : salary
     */
    protected int salary;

    private static final long serialVersionUID = 7363497963508294753L;

    static {
    
        I18n.n("topia.test.common.employe");
        I18n.n("topia.test.common.salary");
    }

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    @Override
    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        super.accept0(visitor);
        visitor.visit(this, PROPERTY_SALARY, int.class, salary);
    }

    @Override
    public void setSalary(int salary) {
        int oldValue = this.salary;
        fireOnPreWrite(PROPERTY_SALARY, oldValue, salary);
        this.salary = salary;
        fireOnPostWrite(PROPERTY_SALARY, oldValue, salary);
    }

    @Override
    public int getSalary() {
        fireOnPreRead(PROPERTY_SALARY, salary);
        int result = this.salary;
        fireOnPostRead(PROPERTY_SALARY, salary);
        return result;
    }

} //EmployeAbstract
