package org.nuiton.topia.it.mapping.test16;

/*-
 * #%L
 * ToPIA :: IT
 * %%
 * Copyright (C) 2004 - 2020 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;

public abstract class B16Abstract extends A16Impl implements B16 {

    /**
     * Nom de l'attribut en BD : code2
     */
    protected String code2;

    private static final long serialVersionUID = 4050816574631982896L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    @Override
    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        super.accept0(visitor);
        visitor.visit(this, PROPERTY_CODE2, String.class, code2);
    }

    @Override
    public void setCode2(String code2) {
        this.code2 = code2;
    }

    @Override
    public String getCode2() {
        String result = this.code2;
        return result;
    }

} //B16Abstract
