package org.nuiton.topia.it.mapping.test7;

/*-
 * #%L
 * ToPIA :: IT
 * %%
 * Copyright (C) 2004 - 2020 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.LinkedList;
import java.util.List;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class A72Abstract extends AbstractTopiaEntity implements A72 {

    /**
     * Nom de l'attribut en BD : roleB72
     */
    protected List<B72> roleB72;

    private static final long serialVersionUID = 3977916947125069110L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_ROLE_B72, List.class, B72.class, roleB72);
    }

    @Override
    public void addRoleB72(B72 roleB72) {
        if (this.roleB72 == null) {
            this.roleB72 = new LinkedList<B72>();
        }
        this.roleB72.add(roleB72);
    }

    @Override
    public void addRoleB72(int index, B72 roleB72) {
        if (this.roleB72 == null) {
            this.roleB72 = new LinkedList<B72>();
        }
        this.roleB72.add(index, roleB72);
    }

    @Override
    public void addAllRoleB72(Iterable<B72> roleB72) {
        if (roleB72 == null) {
            return;
        }
        for (B72 item : roleB72) {
            addRoleB72(item);
        }
    }

    @Override
    public void setRoleB72(List<B72> roleB72) {
        this.roleB72 = roleB72;
    }

    @Override
    public void removeRoleB72(B72 roleB72) {
        if (this.roleB72 == null || !this.roleB72.remove(roleB72)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void removeRoleB72(int index) {
        if (this.roleB72 == null) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        B72 oldValue = this.roleB72.remove(index);
        if (oldValue == null) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearRoleB72() {
        if (this.roleB72 == null) {
            return;
        }
        this.roleB72.clear();
    }

    @Override
    public List<B72> getRoleB72() {
        return roleB72;
    }

    @Override
    public B72 getRoleB72(int index) {
        return TopiaEntityHelper.getEntityByIndex(roleB72, index);
    }

    @Override
    public B72 getRoleB72ByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(roleB72, topiaId);
    }

    @Override
    public List<String> getRoleB72TopiaIds() {
        List<String> topiaIds = new LinkedList<String>();
        List<org.nuiton.topia.it.mapping.test7.B72> tmp = getRoleB72();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeRoleB72() {
        if (roleB72 == null) {
            return 0;
        }
        return roleB72.size();
    }

    @Override
    public boolean isRoleB72Empty() {
        int size = sizeRoleB72();
        return size == 0;
    }

    @Override
    public boolean isRoleB72NotEmpty() {
        boolean empty = isRoleB72Empty();
        return ! empty;
    }

    @Override
    public boolean containsRoleB72(B72 roleB72) {
        boolean contains = this.roleB72 !=null && this.roleB72.contains(roleB72);
        return contains;
    }

} //A72Abstract
