package org.nuiton.topia.it.legacy.topiatest;

/*-
 * #%L
 * ToPIA :: IT
 * %%
 * Copyright (C) 2004 - 2020 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.it.legacy.TopiaItLegacyEntityEnum;
import org.nuiton.topia.it.legacy.topiatest.deletetest.AbstractParty2TopiaDao;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

public abstract class GeneratedPersonneTopiaDao<E extends Personne> extends AbstractParty2TopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) Personne.class;
    }

    @Override
    public TopiaItLegacyEntityEnum getTopiaEntityEnum() {
        return TopiaItLegacyEntityEnum.Personne;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        super.delete(entity);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Personne.PROPERTY_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Personne.PROPERTY_NAME, v);
        return result;
    }

    @Deprecated
    public E findByName(String v) {
        return forNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByName(String v) {
        return forNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOtherNamesContains(String v) {
        return forContains(Personne.PROPERTY_OTHER_NAMES, v);
    }

    @Deprecated
    public E findContainsOtherNames(String v) {
        return forOtherNamesContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsOtherNames(String v) {
        return forOtherNamesContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forGenderIn(Collection<Gender> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Personne.PROPERTY_GENDER, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forGenderEquals(Gender v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Personne.PROPERTY_GENDER, v);
        return result;
    }

    @Deprecated
    public E findByGender(Gender v) {
        return forGenderEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByGender(Gender v) {
        return forGenderEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOtherGenderIn(Collection<Gender> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Personne.PROPERTY_OTHER_GENDER, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOtherGenderEquals(Gender v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Personne.PROPERTY_OTHER_GENDER, v);
        return result;
    }

    @Deprecated
    public E findByOtherGender(Gender v) {
        return forOtherGenderEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByOtherGender(Gender v) {
        return forOtherGenderEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAddressIn(Collection<Address> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Personne.PROPERTY_ADDRESS, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAddressEquals(Address v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Personne.PROPERTY_ADDRESS, v);
        return result;
    }

    @Deprecated
    public E findByAddress(Address v) {
        return forAddressEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByAddress(Address v) {
        return forAddressEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTitleContains(Title v) {
        return forContains(Personne.PROPERTY_TITLE, v);
    }

    @Deprecated
    public E findContainsTitle(Title v) {
        return forTitleContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsTitle(Title v) {
        return forTitleContains(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        return new LinkedList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedPersonneTopiaDao<E extends Personne>
