package org.nuiton.topia.it.mapping.test5;

/*-
 * #%L
 * ToPIA :: IT
 * %%
 * Copyright (C) 2004 - 2020 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.Collection;
import java.util.LinkedList;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class A51Abstract extends AbstractTopiaEntity implements A51 {

    /**
     * Nom de l'attribut en BD : b51
     */
    protected Collection<B51> b51;

    private static final long serialVersionUID = 3775254783551889718L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_B51, Collection.class, B51.class, b51);
    }

    @Override
    public void addB51(B51 b51) {
        if (this.b51 == null) {
            this.b51 = new LinkedList<B51>();
        }
        b51.setA51(this);
        this.b51.add(b51);
    }

    @Override
    public void addAllB51(Iterable<B51> b51) {
        if (b51 == null) {
            return;
        }
        for (B51 item : b51) {
            addB51(item);
        }
    }

    @Override
    public void setB51(Collection<B51> b51) {
        this.b51 = b51;
    }

    @Override
    public void removeB51(B51 b51) {
        if (this.b51 == null || !this.b51.remove(b51)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        b51.setA51(null);
    }

    @Override
    public void clearB51() {
        if (this.b51 == null) {
            return;
        }
        for (B51 item : this.b51) {
            item.setA51(null);
        }
        this.b51.clear();
    }

    @Override
    public Collection<B51> getB51() {
        return b51;
    }

    @Override
    public B51 getB51ByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(b51, topiaId);
    }

    @Override
    public Collection<String> getB51TopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<org.nuiton.topia.it.mapping.test5.B51> tmp = getB51();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeB51() {
        if (b51 == null) {
            return 0;
        }
        return b51.size();
    }

    @Override
    public boolean isB51Empty() {
        int size = sizeB51();
        return size == 0;
    }

    @Override
    public boolean isB51NotEmpty() {
        boolean empty = isB51Empty();
        return ! empty;
    }

    @Override
    public boolean containsB51(B51 b51) {
        boolean contains = this.b51 !=null && this.b51.contains(b51);
        return contains;
    }

} //A51Abstract
