package org.nuiton.topia.it.mapping.test3;

/*-
 * #%L
 * ToPIA :: IT
 * %%
 * Copyright (C) 2004 - 2020 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.Collection;
import java.util.LinkedList;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class A3Abstract extends AbstractTopiaEntity implements A3 {

    /**
     * Nom de l'attribut en BD : b3
     */
    protected Collection<B3> b3;

    private static final long serialVersionUID = 3847027565457389880L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_B3, Collection.class, B3.class, b3);
    }

    @Override
    public void addB3(B3 b3) {
        if (this.b3 == null) {
            this.b3 = new LinkedList<B3>();
        }
        this.b3.add(b3);
    }

    @Override
    public void addAllB3(Iterable<B3> b3) {
        if (b3 == null) {
            return;
        }
        for (B3 item : b3) {
            addB3(item);
        }
    }

    @Override
    public void setB3(Collection<B3> b3) {
        this.b3 = b3;
    }

    @Override
    public void removeB3(B3 b3) {
        if (this.b3 == null || !this.b3.remove(b3)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearB3() {
        if (this.b3 == null) {
            return;
        }
        this.b3.clear();
    }

    @Override
    public Collection<B3> getB3() {
        return b3;
    }

    @Override
    public B3 getB3ByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(b3, topiaId);
    }

    @Override
    public Collection<String> getB3TopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<org.nuiton.topia.it.mapping.test3.B3> tmp = getB3();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeB3() {
        if (b3 == null) {
            return 0;
        }
        return b3.size();
    }

    @Override
    public boolean isB3Empty() {
        int size = sizeB3();
        return size == 0;
    }

    @Override
    public boolean isB3NotEmpty() {
        boolean empty = isB3Empty();
        return ! empty;
    }

    @Override
    public boolean containsB3(B3 b3) {
        boolean contains = this.b3 !=null && this.b3.contains(b3);
        return contains;
    }

} //A3Abstract
