package org.nuiton.topia.it.mapping.test11;

/*-
 * #%L
 * ToPIA :: IT
 * %%
 * Copyright (C) 2004 - 2020 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.HashSet;
import java.util.Set;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class A11BAbstract extends AbstractTopiaEntity implements A11B {

    /**
     * Nom de l'attribut en BD : roleB111
     */
    protected Set<B11B> roleB111;

    private static final long serialVersionUID = 7148447588653818977L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_ROLE_B111, Set.class, B11B.class, roleB111);
    }

    @Override
    public void addRoleB111(B11B roleB111) {
        if (this.roleB111 == null) {
            this.roleB111 = new HashSet<B11B>();
        }
        this.roleB111.add(roleB111);
    }

    @Override
    public void addAllRoleB111(Iterable<B11B> roleB111) {
        if (roleB111 == null) {
            return;
        }
        for (B11B item : roleB111) {
            addRoleB111(item);
        }
    }

    @Override
    public void setRoleB111(Set<B11B> roleB111) {
        this.roleB111 = roleB111;
    }

    @Override
    public void removeRoleB111(B11B roleB111) {
        if (this.roleB111 == null || !this.roleB111.remove(roleB111)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearRoleB111() {
        if (this.roleB111 == null) {
            return;
        }
        this.roleB111.clear();
    }

    @Override
    public Set<B11B> getRoleB111() {
        return roleB111;
    }

    @Override
    public B11B getRoleB111ByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(roleB111, topiaId);
    }

    @Override
    public Set<String> getRoleB111TopiaIds() {
        Set<String> topiaIds = new HashSet<String>();
        Set<org.nuiton.topia.it.mapping.test11.B11B> tmp = getRoleB111();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeRoleB111() {
        if (roleB111 == null) {
            return 0;
        }
        return roleB111.size();
    }

    @Override
    public boolean isRoleB111Empty() {
        int size = sizeRoleB111();
        return size == 0;
    }

    @Override
    public boolean isRoleB111NotEmpty() {
        boolean empty = isRoleB111Empty();
        return ! empty;
    }

    @Override
    public boolean containsRoleB111(B11B roleB111) {
        boolean contains = this.roleB111 !=null && this.roleB111.contains(roleB111);
        return contains;
    }

} //A11BAbstract
