package org.nuiton.topia.it.legacy.topiatest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.it.legacy.AbstractTopiaItLegacyDao;
import org.nuiton.topia.it.legacy.TopiaItLegacyEntityEnum;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Jun 07 16:46:26 CEST 2018")
public abstract class GeneratedCompanyTopiaDao<E extends Company> extends AbstractTopiaItLegacyDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) Company.class;
    }

    @Override
    public TopiaItLegacyEntityEnum getTopiaEntityEnum() {
        return TopiaItLegacyEntityEnum.Company;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            DepartmentTopiaDao dao = topiaDaoSupplier
                    .getDao(Department.class, DepartmentTopiaDao.class);
            List<Department> list = dao
                    .forProperties(Department.PROPERTY_COMPANY, entity)
                    .findAll();
            for (Department item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getCompany())) {
                    item.setCompany(null);
                }
            
            }
        }

        super.delete(entity);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Company.PROPERTY_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Company.PROPERTY_NAME, v);
        return result;
    }

    @Deprecated
    public E findByName(String v) {
        return forNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByName(String v) {
        return forNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSiretIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Company.PROPERTY_SIRET, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSiretEquals(int v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Company.PROPERTY_SIRET, v);
        return result;
    }

    @Deprecated
    public E findBySiret(int v) {
        return forSiretEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySiret(int v) {
        return forSiretEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEmployeContains(Employe v) {
        return forContains(Company.PROPERTY_EMPLOYE, v);
    }

    @Deprecated
    public E findContainsEmploye(Employe v) {
        return forEmployeContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsEmploye(Employe v) {
        return forEmployeContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDepartmentContains(Department v) {
        return forContains(Company.PROPERTY_DEPARTMENT, v);
    }

    @Deprecated
    public E findContainsDepartment(Department v) {
        return forDepartmentContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsDepartment(Department v) {
        return forDepartmentContains(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == Department.class) {
            DepartmentTopiaDao dao =
                topiaDaoSupplier.getDao(Department.class, DepartmentTopiaDao.class);
            tmp = dao.forCompanyEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Department.class, entity);
        if (!list.isEmpty()) {
            result.put(Department.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        {
            BillTopiaDao dao = topiaDaoSupplier
                    .getDao(Bill.class, BillTopiaDao.class);
            List<Bill> findAllByProperties = dao.forProperties("company", entity).findAll();
            if (findAllByProperties != null) {
                tmp.addAll(findAllByProperties);
            }
        }
        if (entity.getDepartment() != null) {
              tmp.addAll(entity.getDepartment());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedCompanyTopiaDao<E extends Company>
