package org.nuiton.topia.it.legacy.topiatest.deletetest;

import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.it.legacy.AbstractTopiaItLegacyEntity;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Thu Sep 07 11:18:33 CEST 2017")
public abstract class Contact2Abstract extends AbstractTopiaItLegacyEntity implements Contact2 {

    /**
     * Nom de l'attribut en BD : contactValue
     */
    protected String contactValue;

    /**
     * Nom de l'attribut en BD : type
     */
    protected String type;

    /**
     * Nom de l'attribut en BD : party2
     */
    protected Collection<Party2> party2;

    private static final long serialVersionUID = 7148679594314643812L;

    static {
    
        I18n.n("topia.test.common.contact2");
        I18n.n("topia.test.common.contactValue");
        I18n.n("topia.test.common.type");
        I18n.n("topia.test.common.party2");
    }

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_CONTACT_VALUE, String.class, contactValue);
        visitor.visit(this, PROPERTY_TYPE, String.class, type);
        visitor.visit(this, PROPERTY_PARTY2, Collection.class, Party2.class, party2);
    }

    @Override
    public void setContactValue(String contactValue) {
        String oldValue = this.contactValue;
        fireOnPreWrite(PROPERTY_CONTACT_VALUE, oldValue, contactValue);
        this.contactValue = contactValue;
        fireOnPostWrite(PROPERTY_CONTACT_VALUE, oldValue, contactValue);
    }

    @Override
    public String getContactValue() {
        fireOnPreRead(PROPERTY_CONTACT_VALUE, contactValue);
        String result = this.contactValue;
        fireOnPostRead(PROPERTY_CONTACT_VALUE, contactValue);
        return result;
    }

    @Override
    public void setType(String type) {
        String oldValue = this.type;
        fireOnPreWrite(PROPERTY_TYPE, oldValue, type);
        this.type = type;
        fireOnPostWrite(PROPERTY_TYPE, oldValue, type);
    }

    @Override
    public String getType() {
        fireOnPreRead(PROPERTY_TYPE, type);
        String result = this.type;
        fireOnPostRead(PROPERTY_TYPE, type);
        return result;
    }

    @Override
    public void addParty2(Party2 party2) {
        fireOnPreWrite(PROPERTY_PARTY2, null, party2);
        if (this.party2 == null) {
            this.party2 = new LinkedList<Party2>();
        }
        if (party2.getContacts() == null) {
            party2.setContacts(new java.util.LinkedList<org.nuiton.topia.it.legacy.topiatest.deletetest.Contact2>());
        }
        party2.getContacts().add(this);
        this.party2.add(party2);
        fireOnPostWrite(PROPERTY_PARTY2, this.party2.size(), null, party2);
    }

    @Override
    public void addAllParty2(Iterable<Party2> party2) {
        if (party2 == null) {
            return;
        }
        for (Party2 item : party2) {
            addParty2(item);
        }
    }

    @Override
    public void setParty2(Collection<Party2> party2) {
        // Copy elements to keep data for fire with new reference
        Collection<Party2> oldValue = this.party2 != null ? new LinkedList<Party2>(this.party2) : null;
        fireOnPreWrite(PROPERTY_PARTY2, oldValue, party2);
        this.party2 = party2;
        fireOnPostWrite(PROPERTY_PARTY2, oldValue, party2);
    }

    @Override
    public void removeParty2(Party2 party2) {
        fireOnPreWrite(PROPERTY_PARTY2, party2, null);
        if (this.party2 == null || !this.party2.remove(party2)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        party2.getContacts().remove(this);
        fireOnPostWrite(PROPERTY_PARTY2, this.party2.size() + 1, party2, null);
    }

    @Override
    public void clearParty2() {
        if (this.party2 == null) {
            return;
        }
        for (Party2 item : this.party2) {
            item.getContacts().remove(this);
        }
        Collection<Party2> oldValue = new LinkedList<Party2>(this.party2);
        fireOnPreWrite(PROPERTY_PARTY2, oldValue, this.party2);
        this.party2.clear();
        fireOnPostWrite(PROPERTY_PARTY2, oldValue, this.party2);
    }

    @Override
    public Collection<Party2> getParty2() {
        return party2;
    }

    @Override
    public Party2 getParty2ByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(party2, topiaId);
    }

    @Override
    public Collection<String> getParty2TopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<org.nuiton.topia.it.legacy.topiatest.deletetest.Party2> tmp = getParty2();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeParty2() {
        if (party2 == null) {
            return 0;
        }
        return party2.size();
    }

    @Override
    public boolean isParty2Empty() {
        int size = sizeParty2();
        return size == 0;
    }

    @Override
    public boolean isParty2NotEmpty() {
        boolean empty = isParty2Empty();
        return ! empty;
    }

    @Override
    public boolean containsParty2(Party2 party2) {
        boolean contains = this.party2 !=null && this.party2.contains(party2);
        return contains;
    }

} //Contact2Abstract
