/*
 * #%L
 * Nuiton Utils
 * 
 * $Id: MonthEnum.java 2619 2014-02-04 06:31:17Z tchemit $
 * $HeadURL: https://svn.nuiton.org/nuiton-utils/tags/nuiton-utils-3.0-rc-8/src/main/java/org/nuiton/util/MonthEnum.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import static org.nuiton.i18n.I18n.t;

/**
 * Une énumération pour représenter les mois d'une année.
 *
 * @author tchemit <chemit@codelutin.com>
 */

public enum MonthEnum {

    JANUARY(t("nuitonutil.month.january")),
    FEBRUARY(t("nuitonutil.month.february")),
    MARCH(t("nuitonutil.month.march")),
    APRIL(t("nuitonutil.month.april")),
    MAY(t("nuitonutil.month.may")),
    JUNE(t("nuitonutil.month.june")),
    JULY(t("nuitonutil.month.july")),
    AUGUST(t("nuitonutil.month.august")),
    SEPTEMBER(t("nuitonutil.month.september")),
    OCTOBER(t("nuitonutil.month.october")),
    NOVEMBER(t("nuitonutil.month.november")),
    DECEMBER(t("nuitonutil.month.december"));

    /** Logger */
    private static final Log log = LogFactory.getLog(MonthEnum.class);

    private final String libelle;

    MonthEnum(String libelle) {
        this.libelle = libelle;
    }

    public String getLibelle() {
        return libelle;
    }

    public static MonthEnum valueOf(String month, MonthEnum defaultValue) {
        MonthEnum monthEnum = null;
        try {
            monthEnum = valueOf(month.toUpperCase());
        } catch (Exception e) {
            log.error(
                    t("nuitonutil.error.unfound.month", month, defaultValue),
                    e);
        }
        return monthEnum == null ? defaultValue : monthEnum;
    }

    @Override
    public String toString() {
        // on force la traduction (au cas où i18n n'était pas ini au moment
        // du chargement de l'enum...)
        return t(libelle);
    }
}
