/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.primitives.DoubleCollection;
import org.apache.commons.collections.primitives.DoubleIterator;
import org.apache.commons.collections.primitives.DoubleList;
import org.apache.commons.collections.primitives.DoubleListIterator;
import org.apache.commons.collections.primitives.adapters.AbstractCollectionDoubleCollection;
import org.apache.commons.collections.primitives.adapters.DoubleCollectionCollection;
import org.apache.commons.collections.primitives.adapters.ListDoubleList;
import org.apache.commons.collections.primitives.adapters.ListIteratorDoubleListIterator;

abstract class AbstractListDoubleList
extends AbstractCollectionDoubleCollection
implements DoubleList {
    AbstractListDoubleList() {
    }

    public void add(int index, double element) {
        this.getList().add(index, new Double(element));
    }

    public boolean addAll(int index, DoubleCollection collection) {
        return this.getList().addAll(index, DoubleCollectionCollection.wrap(collection));
    }

    public double get(int index) {
        return ((Number)this.getList().get(index)).doubleValue();
    }

    public int indexOf(double element) {
        return this.getList().indexOf(new Double(element));
    }

    public int lastIndexOf(double element) {
        return this.getList().lastIndexOf(new Double(element));
    }

    public DoubleListIterator listIterator() {
        return ListIteratorDoubleListIterator.wrap(this.getList().listIterator());
    }

    public DoubleListIterator listIterator(int index) {
        return ListIteratorDoubleListIterator.wrap(this.getList().listIterator(index));
    }

    public double removeElementAt(int index) {
        return ((Number)this.getList().remove(index)).doubleValue();
    }

    public double set(int index, double element) {
        return ((Number)this.getList().set(index, new Double(element))).doubleValue();
    }

    public DoubleList subList(int fromIndex, int toIndex) {
        return ListDoubleList.wrap(this.getList().subList(fromIndex, toIndex));
    }

    public boolean equals(Object obj) {
        if (obj instanceof DoubleList) {
            DoubleList that = (DoubleList)obj;
            if (this == that) {
                return true;
            }
            if (this.size() != that.size()) {
                return false;
            }
            DoubleIterator thisiter = this.iterator();
            DoubleIterator thatiter = that.iterator();
            while (thisiter.hasNext()) {
                if (thisiter.next() == thatiter.next()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.getList()).hashCode();
    }

    protected final Collection getCollection() {
        return this.getList();
    }

    protected abstract List getList();
}

