/*
 * #%L
 * Nuiton Utils :: Nuiton Utils
 * 
 * $Id: DesktopUtil.java 2360 2012-06-11 10:24:36Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-utils/tags/nuiton-utils-2.6.1/nuiton-utils/src/main/java/org/nuiton/util/DesktopUtil.java $
 * %%
 * Copyright (C) 2004 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;

/**
 * Utility class for methods to interact with Desktop Environment
 *
 * @author jcouteau
 * @since 2.4.3
 */
public class DesktopUtil {

    /** Logger. */
    static private Log log = LogFactory.getLog(DesktopUtil.class);

    /**
     * Method to open an URI in the user default web browser. It uses the Java
     * Desktop API on Windows and Gnome environment and xdg-open on other
     * platforms (non-gnome linux distribution for example).
     * <p/>
     * A Bug report have been opened in 2006 so that java.awt.Desktop can
     * support all environments but it is not fixed yet :
     * http://bugs.sun.com/view_bug.do?bug_id=6486393 this utility method should
     * be removed when the bug is fixed.
     *
     * @param uri the URI to open
     */
    public static void browse(URI uri) {
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                if (desktop.isSupported(Desktop.Action.BROWSE)) {

                    desktop.browse(uri);

                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("Browse operation not supported");
                    }
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Desktop not supported");
                }
            }
        } catch (IOException ioe) {
            if (log.isDebugEnabled()) {
                log.debug("Desktop API not supported, launching xdg-open");
            }

            ProcessBuilder pb = new ProcessBuilder("xdg-open", uri.toString());
            try {
                pb.start();
            } catch (IOException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Could not launch browser, there is maybe no " +
                              "default browser configured on the system");
                }
            }

        }

    }

}
