/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.beans.BeanUtil;
import org.nuiton.util.beans.PropertyDiff;

public class BeanMonitor {
    private static final Log log = LogFactory.getLog(BeanMonitor.class);
    protected final List<String> propertyNames;
    protected final Map<String, PropertyDiff> propertyDiffs;
    protected final PropertyChangeListener listener;
    protected Object bean;

    public BeanMonitor(String ... propertyNames) {
        this.propertyNames = Arrays.asList(propertyNames);
        this.propertyDiffs = new LinkedHashMap<String, PropertyDiff>();
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if (!BeanMonitor.this.propertyNames.contains(propertyName)) {
                    return;
                }
                Object newValue = evt.getNewValue();
                Object oldValue = evt.getOldValue();
                if (BeanMonitor.this.propertyDiffs.containsKey(propertyName)) {
                    PropertyDiff propertyDiff = BeanMonitor.this.propertyDiffs.get(propertyName);
                    propertyDiff.setTargetValue(newValue);
                    Object originalValue = propertyDiff.getSourceValue();
                    if (originalValue == null && newValue == null || originalValue != null && originalValue.equals(newValue)) {
                        BeanMonitor.this.propertyDiffs.remove(propertyName);
                    }
                } else {
                    PropertyDiff propertyDiff = new PropertyDiff(propertyName, oldValue, propertyName, newValue, null);
                    BeanMonitor.this.propertyDiffs.put(propertyName, propertyDiff);
                }
            }
        };
    }

    public Object getBean() {
        return this.bean;
    }

    public boolean wasModified() {
        return !this.propertyDiffs.isEmpty();
    }

    public String[] getModifiedProperties() {
        Set<String> propertyNames = this.propertyDiffs.keySet();
        return propertyNames.toArray(new String[propertyNames.size()]);
    }

    public Map<String, Object> getOriginalValues() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (PropertyDiff propertyDiff : this.propertyDiffs.values()) {
            map.put(propertyDiff.getSourceProperty(), propertyDiff.getSourceValue());
        }
        return map;
    }

    public PropertyDiff[] getPropertyDiffs() {
        Collection<PropertyDiff> values = this.propertyDiffs.values();
        return values.toArray(new PropertyDiff[values.size()]);
    }

    public void setBean(Object bean) {
        Object oldBean = this.bean;
        this.bean = bean;
        this.clearModified();
        if (oldBean != null) {
            try {
                BeanUtil.removePropertyChangeListener(this.listener, oldBean);
            }
            catch (Exception eee) {
                log.error((Object)I18n._((String)"nuitonutil.error.could.not.removePCL", (Object[])new Object[]{this.listener, oldBean, eee.getMessage()}));
            }
        }
        if (bean != null) {
            try {
                BeanUtil.addPropertyChangeListener(this.listener, bean);
            }
            catch (Exception eee) {
                log.error((Object)I18n._((String)"nuitonutil.error.could.not.addPCL", (Object[])new Object[]{this.listener, bean, eee.getMessage()}));
            }
        }
    }

    public void clearModified() {
        this.propertyDiffs.clear();
    }
}

