/*
 * #%L
 * Nuiton Utils :: Nuiton Utils
 * 
 * $Id: package-info.java 2162 2011-08-04 12:48:03Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-utils/tags/nuiton-utils-2.4.6/nuiton-utils/src/main/java/org/nuiton/util/decorator/package-info.java $
 * %%
 * Copyright (C) 2004 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
/**
 *
 * This package contains a api to do some decoration over any object.
 *
 * <h1>Decorator api</h1>
 * The {@link org.nuiton.util.decorator.Decorator} has an internal state which
 * is the type of object to decorate and a method to do the decoration :
 * {@link org.nuiton.util.decorator.Decorator#toString(Object)}.
 * <p/>
 * There is some default implementations of a decorator using a simple property,
 * or more complex one using jxpath mecanisms.
 *
 * <h1>DecoratorProvider api</h1>
 * The {@link org.nuiton.util.decorator.DecoratorProvider} api is there to
 * provide some decorators for you,
 *
 * There is a second one {@link org.nuiton.util.decorator.DecoratorMulti18nProvider}
 * which take account of a given locale (so can be used in web context for
 * example).
 *
 * User has to fill method
 * {@link org.nuiton.util.decorator.DecoratorProvider}#loadDecorators()}
 * or
 * {@link org.nuiton.util.decorator.DecoratorMulti18nProvider#loadDecorators(Locale)}
 * to specify which decorators are available.
 *
 * Then it can use the provider using the methods {@code getDecorator(XXX)}
 *
 * <strong>Note:</strong> Decorator can be contextualized so for a same type of
 * object we can provide different way of decorating then.
 *
 * <h1>DecoratorUtil class</h1>
 *
 * This class offers some usefull method to create new decorator via the
 * {@code newXXX} methods and also some method to sort list of objects using a
 * decorator.
 *
 * <strong>Note: </strong> This api comes from the jaxx-runtime project.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.3
 * @see org.nuiton.util.decorator.Decorator
 * @see org.nuiton.util.decorator.DecoratorProvider
 * @see org.nuiton.util.decorator.DecoratorMulti18nProvider
 */
package org.nuiton.util.decorator;

import java.util.Locale;