/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.nuiton.util.beans.Binder;

public class BinderModelBuilder<S, T> {
    protected Binder.BinderModel<S, T> model;
    protected Map<String, PropertyDescriptor> sourceDescriptors;
    protected Map<String, PropertyDescriptor> targetDescriptors;

    public static <S> BinderModelBuilder<S, S> newEmptyBuilder(Class<S> type) {
        return new BinderModelBuilder<S, S>(type, type);
    }

    public static <S, T> BinderModelBuilder<S, T> newEmptyBuilder(Class<S> sourceType, Class<T> targetType) {
        return new BinderModelBuilder<S, T>(sourceType, targetType);
    }

    public static <S> BinderModelBuilder<S, S> newDefaultBuilder(Class<S> sourceType) {
        return BinderModelBuilder.newDefaultBuilder(sourceType, sourceType);
    }

    public static <S, T> BinderModelBuilder<S, T> newDefaultBuilder(Class<S> sourceType, Class<T> targetType) {
        BinderModelBuilder<S, T> builder = BinderModelBuilder.newEmptyBuilder(sourceType, targetType);
        Map<String, PropertyDescriptor> source = builder.sourceDescriptors;
        Map<String, PropertyDescriptor> target = builder.targetDescriptors;
        ArrayList<String> properties = new ArrayList<String>();
        for (String propertyName : source.keySet()) {
            PropertyDescriptor targetDescriptor;
            PropertyDescriptor sourceDescriptor;
            if (!target.containsKey(propertyName) || (sourceDescriptor = source.get(propertyName)).getReadMethod() == null || (targetDescriptor = target.get(propertyName)).getWriteMethod() == null) continue;
            properties.add(propertyName);
        }
        builder.addSimpleProperties(properties.toArray(new String[properties.size()]));
        return builder;
    }

    public BinderModelBuilder<S, T> addSimpleProperties(String ... properties) throws IllegalStateException, NullPointerException {
        for (String property : properties) {
            if (property == null) {
                throw new NullPointerException("parameter 'properties' can not contains a null value");
            }
            this.addProperty0(property, property);
        }
        return this;
    }

    public BinderModelBuilder<S, T> addProperty(String sourceProperty, String targetProperty) throws IllegalStateException, NullPointerException {
        if (sourceProperty == null) {
            throw new NullPointerException("parameter 'sourceProperty' can not be null");
        }
        if (targetProperty == null) {
            throw new NullPointerException("parameter 'targetProperty' can not be null");
        }
        this.addProperty0(sourceProperty, targetProperty);
        return this;
    }

    public BinderModelBuilder<S, T> addProperties(String ... sourceAndTargetProperties) throws IllegalStateException, IllegalArgumentException, NullPointerException {
        if (sourceAndTargetProperties.length % 2 != 0) {
            throw new IllegalArgumentException("must have couple(s) of sourceProperty,targetProperty) but had " + Arrays.toString(sourceAndTargetProperties));
        }
        int max = sourceAndTargetProperties.length / 2;
        for (int i = 0; i < max; ++i) {
            String sourceProperty = sourceAndTargetProperties[2 * i];
            String targetProperty = sourceAndTargetProperties[2 * i + 1];
            if (sourceProperty == null) {
                throw new NullPointerException("parameter 'sourceAndTargetProperties' can not contains a null value");
            }
            if (targetProperty == null) {
                throw new NullPointerException("parameter 'sourceAndTargetProperties' can not contains a null value");
            }
            this.addProperty0(sourceProperty, targetProperty);
        }
        return this;
    }

    public BinderModelBuilder<S, T> addBinder(String propertyName, Binder<?, ?> binder) {
        if (!this.model.containsSourceProperty(propertyName)) {
            throw new IllegalArgumentException("source property '" + propertyName + "' " + " is NOT registred.");
        }
        PropertyDescriptor descriptor = this.sourceDescriptors.get(propertyName);
        Class<?> type = descriptor.getPropertyType();
        if (!Collection.class.isAssignableFrom(type) && !binder.model.getSourceType().isAssignableFrom(type)) {
            throw new IllegalStateException("source property '" + propertyName + "' has not the same type [" + type + "] of the binder [" + binder.model.getSourceType() + "].");
        }
        this.model.addBinder(propertyName, binder);
        return this;
    }

    public BinderModelBuilder<S, T> addCollectionStrategy(Binder.CollectionStrategy strategy, String ... propertyNames) {
        for (String propertyName : propertyNames) {
            if (!this.model.containsSourceProperty(propertyName)) {
                throw new IllegalArgumentException("source property '" + propertyName + "' " + " is NOT registred.");
            }
            PropertyDescriptor descriptor = this.sourceDescriptors.get(propertyName);
            Class<?> type = descriptor.getPropertyType();
            if (!Collection.class.isAssignableFrom(type)) {
                throw new IllegalStateException("source property '" + propertyName + "' is not a collection type [" + type + "]");
            }
            this.model.addCollectionStrategy(propertyName, strategy);
        }
        return this;
    }

    protected BinderModelBuilder(Class<S> sourceType, Class<T> targetType) {
        if (sourceType == null) {
            throw new NullPointerException("sourceType can not be null");
        }
        if (targetType == null) {
            throw new NullPointerException("targetType can not be null");
        }
        if (this.model != null) {
            throw new IllegalStateException("there is already a binderModel in construction, release it with the method createBinder before using this method.");
        }
        this.model = new Binder.BinderModel<S, T>(sourceType, targetType);
        this.sourceDescriptors = new TreeMap<String, PropertyDescriptor>();
        BinderModelBuilder.loadDescriptors(this.model.getSourceType(), this.sourceDescriptors);
        this.targetDescriptors = new TreeMap<String, PropertyDescriptor>();
        BinderModelBuilder.loadDescriptors(this.model.getTargetType(), this.targetDescriptors);
    }

    protected void addProperty0(String sourceProperty, String targetProperty) {
        Class<?> targetType;
        PropertyDescriptor sourceDescriptor = this.sourceDescriptors.get(sourceProperty);
        if (sourceDescriptor == null) {
            throw new IllegalArgumentException("no property '" + sourceProperty + "' " + "found on type " + this.model.getSourceType());
        }
        Method readMethod = sourceDescriptor.getReadMethod();
        if (readMethod == null) {
            throw new IllegalArgumentException("property '" + sourceProperty + "' " + "is not readable on type " + this.model.getSourceType());
        }
        PropertyDescriptor targetDescriptor = this.targetDescriptors.get(targetProperty);
        if (targetDescriptor == null) {
            throw new IllegalArgumentException("no property '" + targetProperty + "' " + "found on type " + this.model.getTargetType());
        }
        Method writeMethod = sourceDescriptor.getWriteMethod();
        if (writeMethod == null) {
            throw new IllegalArgumentException("property '" + targetProperty + "' " + "is not writable on type " + this.model.getTargetType());
        }
        Class<?> sourceType = sourceDescriptor.getPropertyType();
        if (!sourceType.equals(targetType = targetDescriptor.getPropertyType())) {
            throw new IllegalArgumentException("source property '" + sourceProperty + "' and target property '" + targetProperty + "' are not compatible ( sourceType : " + sourceType + " vs targetType :" + targetType + ')');
        }
        if (this.model.containsSourceProperty(sourceProperty)) {
            this.model.removeBinding(sourceProperty);
        }
        if (this.model.containsTargetProperty(targetProperty)) {
            throw new IllegalArgumentException("destination property '" + targetProperty + "' " + " was already registred.");
        }
        this.model.addBinding(sourceDescriptor, targetDescriptor);
    }

    protected Binder.BinderModel<S, T> getModel() {
        return this.model;
    }

    protected void clear() {
        this.sourceDescriptors = null;
        this.targetDescriptors = null;
        this.model = null;
    }

    protected static void loadDescriptors(Class<?> type, Map<String, PropertyDescriptor> descriptors) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
                if (descriptors.containsKey(descriptor.getName())) continue;
                descriptors.put(descriptor.getName(), descriptor);
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Could not obtain bean properties descriptors for source type " + type, e);
        }
        Class<?>[] interfaces = type.getInterfaces();
        for (Class<?> i : interfaces) {
            BinderModelBuilder.loadDescriptors(i, descriptors);
        }
        Class<?> superClass = type.getSuperclass();
        if (superClass != null && !Object.class.equals(superClass)) {
            BinderModelBuilder.loadDescriptors(superClass, descriptors);
        }
    }
}

