/* *##% Nuiton utilities library
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%* */

/* *
 * ProgressMonitorFrame.java
 *
 * Created: 13 sept. 06 11:05:41
 *
 * @author poussin
 * @version $Revision: 1637 $
 *
 * Last update: $Date: 2009-06-21 04:53:31 +0200 (dim., 21 juin 2009) $
 * by : $Author: tchemit $
 */

package org.nuiton.log;

import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingConstants;
import javax.swing.WindowConstants;
import java.awt.Component;

// 20060923 poussin FIXME we must can used i18n in util lib. (perhaps put i18n directly in util lib)
//import static org.nuiton.i18n.I18n._;

/** @author poussin */

public class ProgressMonitorFrame extends JFrame {

    /** serialVersionUID */
    private static final long serialVersionUID = 3878314562707954612L;
    protected LutinLog lutinLog;
    protected JLabel label;
    protected JProgressBar progress;
    protected JButton cancel;
    protected MonitorMapper monitorMapper;

    /**
     * @param lutinLog       log that ProgressMonitorFrame must monitor
     * @param extraComponent optionnal (can be null) user component to put in
     *                       frame
     */
    public ProgressMonitorFrame(LutinLog lutinLog, Component extraComponent) {
        super("ProgressMonitor");

        this.lutinLog = lutinLog;

        Box box = Box.createVerticalBox();

        if (extraComponent != null) {
            box.add(extraComponent);
        }

        label = new JLabel("Message");
        label.setHorizontalTextPosition(SwingConstants.CENTER);
        box.add(label);

        progress = new JProgressBar();
        progress.setStringPainted(true);
        box.add(progress);

        cancel = new JButton();
        cancel.setText("Cancel"); // TODO i18n
        box.add(cancel);

        this.add(box);
        this.setDefaultCloseOperation(WindowConstants.HIDE_ON_CLOSE);
        this.pack();

        monitorMapper = new MonitorMapper(lutinLog, null, label, progress, cancel, true);
    }


}


