/*
 * #%L
 * Maven License Plugin
 * 
 * $Author: tchemit $
 * $LastChangedDate: 2010-04-10 22:45:56 +0200 (sam., 10 avril 2010) $
 * $LastChangedRevision: 1735 $
 * $Id: PropertiesFileHeaderTransformer.java 1735 2010-04-10 20:45:56Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/maven-license-plugin/tags/maven-license-plugin-2.1/src/main/java/org/nuiton/license/plugin/header/transformer/PropertiesFileHeaderTransformer.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.license.plugin.header.transformer;

/**
 * Implementation of {@link FileHeaderTransformer} for properties format.
 *
 * @author tchemit <chemit@codelutin.com>
 * @plexus.component role-hint="properties"
 * @since 2.1
 */
public class PropertiesFileHeaderTransformer extends AbstractFileHeaderTransformer {

    public static final String NAME = "properties";

    public static final String DESCRIPTION = "header transformer with properties file comment style";

    public static final String COMMENT_LINE_PREFIX = "# ";

    public static final String COMMENT_START_TAG = "###";

    public static final String COMMENT_END_TAG = "###";

    public PropertiesFileHeaderTransformer() {
        super(NAME,
              DESCRIPTION,
              COMMENT_START_TAG,
              COMMENT_END_TAG,
              COMMENT_LINE_PREFIX
        );
    }
}
