/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license.plugin;

import java.util.Iterator;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.nuiton.license.plugin.header.generator.HeaderGenerator;

public class GeneratorListMojo
extends AbstractMojo {
    protected boolean detail;
    protected Map<String, HeaderGenerator> _generators;

    public void execute() throws MojoExecutionException, MojoFailureException {
        StringBuilder buffer = new StringBuilder("\n");
        buffer.append("\n\n-------------------------------------------------------------------------------\n");
        buffer.append("                           maven-license-plugin\n");
        buffer.append("-------------------------------------------------------------------------------\n\n");
        if (this._generators == null || this._generators.isEmpty()) {
            buffer.append("No generator found.\n\n");
        } else {
            buffer.append("List of available generators :\n\n");
            Iterator<Map.Entry<String, HeaderGenerator>> i$ = this._generators.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry<String, HeaderGenerator> stringHeaderGeneratorEntry;
                Map.Entry<String, HeaderGenerator> e = stringHeaderGeneratorEntry = i$.next();
                HeaderGenerator generator = e.getValue();
                buffer.append("  - ").append(e.getKey()).append(" : ").append(generator.getDescription());
                buffer.append("\n");
                if (!this.detail) continue;
                buffer.append("\n   example : \n").append(generator.getHeader("content ")).append('\n');
            }
        }
        this.getLog().info((CharSequence)buffer.toString());
    }
}

