/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix;

import org.nuiton.math.matrix.MapFunction;
import org.nuiton.math.matrix.VectorForEachFunction;
import org.nuiton.math.matrix.VectorIterator;

public interface Vector {
    public void init(long var1);

    public String getInfo();

    public long getNumberOfAssignedValue();

    public VectorIterator iterator();

    public VectorIterator iteratorNotZero();

    @Deprecated
    public double getMaxOccurence();

    public double getMaxOccurrence();

    public double getValue(long var1);

    public void setValue(long var1, double var3);

    public long size();

    public boolean isImplementedPaste(Vector var1);

    default public boolean isImplementedAdd(Vector v) {
        return true;
    }

    default public boolean isImplementedMinus(Vector v) {
        return true;
    }

    public boolean isImplementedMap();

    public void paste(Vector var1);

    default public void add(Vector v) {
        v.forEachNotZero((pos, val) -> {
            double value = this.getValue(pos);
            this.setValue(pos, value + val);
        });
    }

    default public void minus(Vector v) {
        v.forEachNotZero((pos, val) -> {
            double value = this.getValue(pos);
            this.setValue(pos, value - val);
        });
    }

    public void map(MapFunction var1);

    default public void forEach(VectorForEachFunction f) {
        long max = this.size();
        for (long i = 0L; i < max; ++i) {
            double val = this.getValue(i);
            f.apply(i, val);
        }
    }

    default public void forEachNotZero(VectorForEachFunction f) {
        long max = this.size();
        for (long i = 0L; i < max; ++i) {
            double val = this.getValue(i);
            if (val == 0.0) continue;
            f.apply(i, val);
        }
    }
}

