/*
 * #%L
 * NuitonMatrix
 * 
 * $Id: FloatBigVector.java 471 2014-04-10 12:44:04Z bpoussin $
 * $HeadURL: https://svn.nuiton.org/nuiton-matrix/tags/nuiton-matrix-2.4/nuiton-matrix/src/main/java/org/nuiton/math/matrix/FloatBigVector.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.math.matrix;

import java.util.Arrays;

/**
 * FloatBigVector.
 *
 * Created: 6 octobre 2005 02:54:36 CEST
 *
 * @author Benjamin POUSSIN <poussin@codelutin.com>
 * @version $Revision: 471 $
 *
 * Last update: $Date: 2014-04-10 14:44:04 +0200 (Thu, 10 Apr 2014) $
 * by : $Author: bpoussin $
 */
public class FloatBigVector implements Vector { // FloatBigVector

    protected float data[] = null;

    public FloatBigVector() {
    }

    public FloatBigVector(int capacity) {
        init(capacity);
    }

    @Override
    public void init(int capacity) {
        if (data == null) {
            data = new float[capacity];
        }
    }

    @Override
    public int size() {
        return data.length;
    }

    @Deprecated
    @Override
    public double getMaxOccurence() {
        return getMaxOccurrence();
    }
    
    @Override
    public double getMaxOccurrence() {
        return MatrixHelper.maxOccurrence(data);
    }

    @Override
    public double getValue(int pos) {
        return data[pos];
    }

    @Override
    public void setValue(int pos, double value) {
        data[pos] = (float) value;
    }

    @Override
    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof FloatBigVector) {
            FloatBigVector other = (FloatBigVector) o;
            result = Arrays.equals(this.data, other.data);
        } else if (o instanceof Vector) {
            Vector other = (Vector) o;
            result = true;
            for (int i = 0; i < size() && result; i++) {
                result = getValue(i) == other.getValue(i);
            }
        }
        return result;
    }

    @Override
    public boolean isImplementedPaste(Vector v) {
        return v instanceof FloatBigVector;
    }

    @Override
    public boolean isImplementedAdd(Vector v) {
        return v instanceof FloatBigVector;
    }

    @Override
    public boolean isImplementedMinus(Vector v) {
        return v instanceof FloatBigVector;
    }

    @Override
    public boolean isImplementedMap() {
        return true;
    }

    @Override
    public void paste(Vector v) {
        FloatBigVector fbv = (FloatBigVector) v;
        System.arraycopy(fbv.data, 0, this.data, 0, this.size());
    }

    @Override
    public void add(Vector v) {
        FloatBigVector fbv = (FloatBigVector) v;
        for (int i = 0; i < data.length; i++) {
            data[i] += fbv.data[i];
        }
    }

    @Override
    public void minus(Vector v) {
        FloatBigVector fbv = (FloatBigVector) v;
        for (int i = 0; i < data.length; i++) {
            data[i] -= fbv.data[i];
        }
    }

    @Override
    public void map(MapFunction f) {
        for (int i = 0; i < data.length; i++) {
            data[i] = (float) f.apply(data[i]);
        }
    }

} // FloatBigVector

