/*
 * #%L
 * 
 * 
 * $Id: MatrixFilter.java 348 2011-04-08 14:03:40Z echatellier $
 * $HeadURL: https://nuiton.org/svn/nuiton-matrix/tags/nuiton-matrix-2.3.3/nuiton-matrix-gui/src/main/java/org/nuiton/math/matrix/viewer/MatrixFilter.java $
 * %%
 * Copyright (C) 2011 Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.math.matrix.viewer;

import org.nuiton.math.matrix.MatrixND;

/**
 * Matrix filtering used by matrix panel viewer.
 * 
 * @author chatellier
 * @version $Revision: 348 $
 * 
 * Last update : $Date: 2011-04-08 16:03:40 +0200 (Fri, 08 Apr 2011) $
 * By : $Author: echatellier $
 */
public interface MatrixFilter {

    /**
     * Filter input matrix.
     * 
     * Called after submatrix creation on selected dimension and applied sum action.
     * 
     * This method can be considerer as "main filter".
     * 
     * @param matrix matrix to filter
     * @return filtered matrix
     */
    public MatrixND filter(MatrixND matrix);

    /**
     * Apply filter on matrix after dimension summing.
     * 
     * @param matrix matrix to filter
     * @param dim dimension concerned by summing
     * @param sumStep sumStep summing
     * @return filtered matrix
     */
    public MatrixND filterDimension(MatrixND matrix, int dim, int sumStep);
}
