/*
 * #%L
 * JRst :: Doxia module
 * 
 * $Id: JrstParser.java 685 2012-05-29 15:37:18Z jpages $
 * $HeadURL: http://svn.nuiton.org/svn/jrst/branches/jrst-docutils-jython/doxia-module-jrst/src/main/java/org/nuiton/jrst/JrstParser.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.jrst;

import java.io.File;
import java.io.FileWriter;
import java.io.Reader;
import java.io.StringReader;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.doxia.module.xdoc.XdocParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.util.IOUtil;
import org.dom4j.Document;

/**
 * Parse an RST model, transform it into xdoc model and emit events into the
 * specified doxia Sink.
 * 
 * @author <a href="mailto:chatellier@codelutin.com">Eric Chatellier</a>
 * @version $Id: JrstParser.java 685 2012-05-29 15:37:18Z jpages $
 * @since 0.9.0
 * @plexus.component role="org.apache.maven.doxia.parser.Parser" role-hint="jrst"
 */
public class JrstParser extends XdocParser {

    @Override
    public void parse(Reader source, Sink sink) throws ParseException {

        try {
            // Write the source in a file to use it with JRST
            File sourceFile = File.createTempFile("source",".rst");
            FileWriter fileWriter = new FileWriter(sourceFile);
            IOUtil.copy(source, fileWriter);

            // Simple generation of the xml file
            Document doc = JRST.generateSimpleDoc(sourceFile, JRST.UTF_8);

            // Application of xsl stylesheets
            doc = JRST.generateXml(doc, JRST.TYPE_XDOC);

            // Give xsl result to XDoc parser
            Reader reader = new StringReader(doc.asXML());
            super.parse(reader, sink);
        } catch (Exception e) {
            throw new ParseException("Can't parse rst file", e);
        }

    }
}
