/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin.announcement;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.changes.model.Action;
import org.apache.maven.plugins.changes.model.Release;
import org.apache.velocity.Template;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.codehaus.plexus.util.StringUtils;
import org.nuiton.jredmine.model.Attachment;

public class AnnouncementGenerator {
    private static final String URL_TOKEN = "%URL%";
    private static final String ATTACHMENT_TOKEN = "%FILE%";
    private final String url;
    private final String attachmentLinkTemplate;
    private final Log log;

    public AnnouncementGenerator(Log log, String url, String attachmentLinkTemplate) {
        this.log = log;
        this.url = url;
        this.attachmentLinkTemplate = attachmentLinkTemplate;
    }

    public Map<Attachment, String> getAttachmentsUrls(Attachment[] attachments) {
        boolean hasAttachmentLinks = this.canGenerateAttachmentLinks();
        HashMap<Attachment, String> urls = null;
        if (hasAttachmentLinks) {
            urls = new HashMap<Attachment, String>();
            if (hasAttachmentLinks) {
                for (Attachment a : attachments) {
                    String u = this.parseAttachmentLink(a.getId() + "");
                    urls.put(a, u);
                }
            }
        } else {
            this.getLog().warn((CharSequence)"can not render attachments urls");
        }
        return urls;
    }

    public void doGenerate(VelocityEngine engine, Context context, File out, String templatePath, String templateEncoding) throws MojoExecutionException {
        try {
            if (!out.getParentFile().exists()) {
                out.getParentFile().mkdirs();
            }
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(out), templateEncoding);
            Template velocityTemplate = engine.getTemplate(templatePath, templateEncoding);
            velocityTemplate.merge(context, (Writer)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (ResourceNotFoundException rnfe) {
            throw new MojoExecutionException("Resource not found.", (Exception)((Object)rnfe));
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.toString(), e);
        }
    }

    public boolean canGenerateAttachmentLinks() {
        return !StringUtils.isBlank((String)this.attachmentLinkTemplate) && (!StringUtils.isBlank((String)this.url) || this.attachmentLinkTemplate.indexOf(URL_TOKEN) < 0);
    }

    protected String parseAttachmentLink(String id) {
        String issueLink = this.attachmentLinkTemplate;
        String parseLink = issueLink.replaceFirst(ATTACHMENT_TOKEN, id);
        if (parseLink.indexOf(URL_TOKEN) >= 0) {
            String u = this.url.substring(0, this.url.lastIndexOf("/"));
            parseLink = parseLink.replaceFirst(URL_TOKEN, u);
        }
        return parseLink;
    }

    public Release getLatestRelease(List<?> releases, String releaseVersion) throws MojoExecutionException {
        boolean isFound;
        Release release;
        String pomVersion = releaseVersion;
        this.getLog().debug((CharSequence)("Found " + releases.size() + " releases."));
        for (Object release1 : releases) {
            release = (Release)release1;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("The release: " + release.getVersion() + " has " + release.getActions().size() + " actions."));
            }
            if (release.getVersion() == null || !release.getVersion().equals(pomVersion)) continue;
            boolean isFound2 = true;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Found the correct release: " + release.getVersion()));
                this.logRelease(release);
            }
            return release;
        }
        release = this.getRelease(releases, pomVersion);
        boolean bl = isFound = release != null;
        if (!isFound) {
            throw new MojoExecutionException("Couldn't find the release '" + pomVersion + "' among the supplied releases.");
        }
        return release;
    }

    protected Release getRelease(List<?> releases, String version) {
        for (Object release1 : releases) {
            Release release = (Release)release1;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("The release: " + release.getVersion() + " has " + release.getActions().size() + " actions."));
            }
            if (release.getVersion() == null || !release.getVersion().equals(version)) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Found the correct release: " + release.getVersion()));
                this.logRelease(release);
            }
            return release;
        }
        return null;
    }

    private void logRelease(Release release) {
        for (Object o : release.getActions()) {
            Action action = (Action)o;
            this.getLog().debug((CharSequence)("o " + action.getType()));
            this.getLog().debug((CharSequence)("issue : " + action.getIssue()));
            this.getLog().debug((CharSequence)("action : " + action.getAction()));
            this.getLog().debug((CharSequence)("dueTo : " + action.getDueTo()));
            this.getLog().debug((CharSequence)("dev : " + action.getDev()));
        }
    }

    protected Log getLog() {
        return this.log;
    }
}

