/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin.announcement;

import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.changes.ChangesXML;
import org.apache.maven.plugins.changes.model.Release;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.velocity.VelocityComponent;
import org.nuiton.jredmine.plugin.AbstractRedmineMojo;
import org.nuiton.jredmine.plugin.announcement.AnnouncementGenerator;
import org.nuiton.plugin.PluginHelper;

public abstract class AbstractAnnouncementMojo
extends AbstractRedmineMojo {
    private File templateOutputDirectory;
    private File xmlPath;
    private String templateDirectory;
    private String templateEncoding;
    private Map<String, Object> announceParameters;
    private String groupId;
    private String artifactId;
    private String projectUrl;
    private String packaging;
    private String finalName;
    private String basedir;
    private String urlDownload;
    private String developmentTeam;
    private String introduction;
    private boolean runOnce;
    private VelocityComponent velocity;

    protected abstract String getAnnouncementTemplate();

    protected AbstractAnnouncementMojo() {
        super(true, false, true);
    }

    @Override
    protected boolean isRunOnce() {
        return this.runOnce;
    }

    @Override
    protected boolean checkRunOnceDone() {
        String template = this.getAnnouncementTemplate();
        File out = new File(this.templateOutputDirectory, template);
        Date buildStartTime = this.session == null ? null : this.session.getStartTime();
        Date newStartTime = out.exists() ? new Date(out.lastModified()) : null;
        boolean checkRunOnceDone = this.checkRunOnceDone(this.runOnce, true, buildStartTime, newStartTime);
        return checkRunOnceDone;
    }

    @Override
    protected boolean init() throws Exception {
        this.versionId = PluginHelper.removeSnapshotSuffix((String)this.versionId);
        this.runOnceDone = false;
        if (this.isRunOnce()) {
            this.runOnceDone = this.checkRunOnceDone();
            if (this.runOnceDone) {
                return true;
            }
        }
        if (!super.init()) {
            return false;
        }
        if (!this.xmlPath.exists()) {
            this.getLog().warn((CharSequence)("can not find redmine-template at " + this.xmlPath + ", goal is skip"));
            return false;
        }
        if (StringUtils.isEmpty((String)this.templateEncoding)) {
            this.templateEncoding = ReaderFactory.FILE_ENCODING;
            this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + this.templateEncoding + ", i.e. build is platform dependent!"));
        }
        if (this.introduction == null || this.introduction.trim().isEmpty()) {
            this.introduction = this.project.getUrl();
        }
        return true;
    }

    @Override
    protected void doAction() throws Exception {
        if (this.isRunOnceDone()) {
            this.getLog().info((CharSequence)"skip goal, runOnce flag is on, and was already executed.");
            return;
        }
        ChangesXML changesXml = new ChangesXML(this.xmlPath, this.getLog());
        List releases = changesXml.getReleaseList();
        String template = this.getAnnouncementTemplate();
        File out = new File(this.templateOutputDirectory, template);
        if (this.verbose) {
            this.getLog().info((CharSequence)("destination file " + out));
        }
        this.getLog().info((CharSequence)("Creating announcement [" + template + "] from " + this.xmlPath));
        VelocityEngine engine = this.velocity.getEngine();
        engine.setApplicationAttribute((Object)"baseDirectory", (Object)this.basedir);
        AnnouncementGenerator generator = new AnnouncementGenerator(this.getLog(), this.projectUrl, "");
        Context context = this.createVelocityContext(generator, releases);
        generator.doGenerate(engine, context, out, this.templateDirectory + "/" + template, this.templateEncoding);
        this.getLog().info((CharSequence)("Created  announcement [" + template + "] in  " + out));
    }

    public Context createVelocityContext(AnnouncementGenerator generator, List<?> releases) throws MojoExecutionException {
        VelocityContext context = new VelocityContext();
        context.put("releases", releases);
        context.put("groupId", (Object)this.groupId);
        context.put("artifactId", (Object)this.artifactId);
        context.put("version", (Object)this.versionId);
        context.put("packaging", (Object)this.packaging);
        context.put("url", (Object)this.projectUrl);
        Release release = generator.getLatestRelease(releases, this.versionId);
        context.put("release", (Object)release);
        context.put("introduction", (Object)this.introduction);
        context.put("developmentTeam", (Object)this.developmentTeam);
        context.put("finalName", (Object)this.finalName);
        context.put("urlDownload", (Object)this.urlDownload);
        context.put("project", (Object)this.project);
        if (this.announceParameters == null) {
            context.put("announceParameters", (Object)Collections.EMPTY_MAP);
        } else {
            context.put("announceParameters", this.announceParameters);
        }
        return context;
    }
}

