/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin;

import java.text.ParseException;
import java.util.Date;
import org.apache.maven.plugin.MojoExecutionException;
import org.nuiton.jredmine.model.ModelHelper;
import org.nuiton.jredmine.model.Version;
import org.nuiton.jredmine.plugin.AbstractRedmineMojo;
import org.nuiton.plugin.PluginHelper;

public class NextVersionMojo
extends AbstractRedmineMojo {
    protected String versionDescription;
    private String effectiveDate;
    private String previousVersionName;
    private boolean skipNextVersion;
    protected boolean dryRun;
    private boolean runOnce;
    private Date date;

    public NextVersionMojo() {
        super(true, false, true);
    }

    @Override
    protected boolean isGoalSkip() {
        return this.skipNextVersion;
    }

    @Override
    protected boolean isRunOnce() {
        return this.runOnce;
    }

    @Override
    protected boolean checkRunOnceDone() {
        return this.isRunOnce() && !this.isExecutionRoot();
    }

    @Override
    protected boolean init() throws Exception {
        if (this.versionId == null || this.versionId.trim().isEmpty()) {
            throw new MojoExecutionException("required a versionId parameter");
        }
        this.versionId = PluginHelper.removeSnapshotSuffix((String)this.versionId);
        this.runOnceDone = false;
        if (this.isRunOnce()) {
            this.runOnceDone = this.checkRunOnceDone();
            if (this.runOnceDone) {
                return true;
            }
        }
        if (this.effectiveDate != null && !this.effectiveDate.trim().isEmpty()) {
            try {
                this.date = this.dateFormat.parse(this.effectiveDate);
            }
            catch (ParseException e) {
                throw new MojoExecutionException("could not parse effectivate date " + this.effectiveDate + " for reason " + e.getMessage(), (Exception)e);
            }
        }
        return super.init();
    }

    @Override
    protected void doAction() throws Exception {
        if (this.isRunOnceDone()) {
            this.getLog().info((CharSequence)"skip goal, runOnce flag is on, and was already executed.");
            return;
        }
        if (this.dryRun) {
            this.getLog().info((CharSequence)"\n  dryRun flag is on, no data will be send!\n");
        }
        Version[] versions = this.service.getVersions(this.projectId);
        Version v = ModelHelper.byVersionName((String)this.versionId, (Version[])versions);
        boolean usePreviousVersion = false;
        if (this.previousVersionName != null && !this.previousVersionName.trim().isEmpty()) {
            Version previousVersion = ModelHelper.byVersionName((String)this.previousVersionName, (Version[])versions);
            if (previousVersion == null) {
                this.getLog().warn((CharSequence)("can not find the previous version " + this.previousVersionName));
            } else {
                usePreviousVersion = true;
            }
        }
        if (v == null) {
            v = new Version();
            v.setName(this.versionId);
        }
        if (this.versionDescription != null && !this.versionDescription.trim().isEmpty()) {
            v.setDescription(this.versionDescription.trim());
        }
        if (this.date != null) {
            v.setEffectiveDate(this.date);
        }
        this.releaseVersion = v;
        if (!this.dryRun) {
            this.getLog().info((CharSequence)("next version " + this.releaseVersion.getName() + (usePreviousVersion ? " from previous version " + this.previousVersionName : "")));
            this.service.nextVersion(this.projectId, usePreviousVersion ? this.previousVersionName : null, this.releaseVersion);
        }
    }
}

