/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.nuiton.jredmine.model.News;
import org.nuiton.jredmine.plugin.AbstractRedmineMojoWithProject;
import org.nuiton.jredmine.plugin.DryRunAware;
import org.nuiton.plugin.PluginHelper;

@Mojo(name="publish-news", requiresOnline=true, requiresProject=true)
public class PublishNewsMojo
extends AbstractRedmineMojoWithProject
implements DryRunAware {
    @Parameter(property="redmine.anonymous", defaultValue="false")
    protected boolean anonymous;
    @Parameter(property="redmine.newsContentFile", required=true)
    protected File newsContentFile;
    @Parameter(property="redmine.newsSummary")
    protected String newsSummary;
    @Parameter(property="redmine.newsTitle", required=true)
    protected String newsTitle;
    @Parameter(property="redmine.skipPublishNews", defaultValue="false")
    protected boolean skipPublishNews;
    @Parameter(property="redmine.dryRun", defaultValue="false")
    protected boolean dryRun;
    @Parameter(property="redmine.runOnce", defaultValue="true")
    protected boolean runOnce;

    public PublishNewsMojo() {
        super(true);
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    @Override
    public boolean isDryRun() {
        return this.dryRun;
    }

    @Override
    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    @Override
    protected boolean isGoalSkip() {
        return this.skipPublishNews;
    }

    @Override
    protected boolean checkRunOnceDone() {
        return this.isRunOnce() && !this.isExecutionRoot();
    }

    @Override
    protected boolean isRunOnce() {
        return this.runOnce;
    }

    @Override
    protected void init() throws Exception {
        this.runOnceDone = false;
        if (this.isRunOnce()) {
            this.runOnceDone = this.checkRunOnceDone();
            if (this.runOnceDone) {
                return;
            }
        }
        if (this.newsSummary == null || this.newsSummary.trim().isEmpty()) {
            this.newsSummary = this.project.getUrl();
        }
        if (!this.newsContentFile.exists()) {
            throw new MojoExecutionException("could not find the template " + this.newsContentFile);
        }
        this.newsTitle = this.newsTitle.trim();
        if (this.newsTitle.length() > 60) {
            this.getLog().warn((CharSequence)("News title can not be longer than 60 caracters, but was " + this.newsTitle.length()));
            this.newsTitle = this.newsTitle.substring(0, 59);
            this.getLog().warn((CharSequence)("will use the restricted title : " + this.newsTitle));
        }
        super.init();
    }

    @Override
    protected void doAction() throws Exception {
        if (this.dryRun) {
            this.getLog().info((CharSequence)"\n  dryRun flag is on, no data will be send!\n");
        }
        News news = new News();
        news.setAuthorId(this.releaseUser.getId());
        news.setProjectId(this.releaseProject.getId());
        news.setTitle(this.newsTitle);
        news.setSummary(this.newsSummary);
        String newsContent = PluginHelper.readAsString((File)this.newsContentFile, (String)this.encoding);
        news.setDescription(newsContent);
        if (this.dryRun) {
            this.getLog().info((CharSequence)("news title   : " + news.getTitle()));
            this.getLog().info((CharSequence)("news summary : " + news.getSummary()));
            this.getLog().info((CharSequence)("news content :\n" + newsContent));
            return;
        }
        this.getLog().info((CharSequence)("publish news " + news.getTitle()));
        if (this.verbose) {
            this.getLog().info((CharSequence)("redmine announcement :\n" + newsContent));
        }
        news = this.service.addNews(this.projectId, news);
        if (this.verbose) {
            this.getLog().info((CharSequence)("done. news id : " + news.getId()));
        }
    }
}

