/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin;

import java.net.URL;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.nuiton.helper.plugin.ShareServerSecretPlugin;
import org.nuiton.jredmine.RedmineService;
import org.nuiton.jredmine.RedmineServiceConfiguration;
import org.nuiton.jredmine.RedmineServiceImplementor;
import org.nuiton.plugin.AbstractPlugin;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;

@Mojo(name="login", requiresOnline=true, requiresProject=true)
public class LoginMojo
extends AbstractPlugin
implements RedmineServiceConfiguration {
    @Component
    protected MavenProject project;
    @Parameter(property="redmine.url")
    protected URL url;
    @Parameter(property="redmine.verbose", defaultValue="${maven.verbose}")
    protected boolean verbose;
    @Parameter(property="redmine.checkLogin", defaultValue="false")
    protected boolean checkLogin;
    @Parameter(property="redmine.safe", defaultValue="true")
    protected boolean safe;
    @Parameter(property="redmine.serverId", required=true)
    protected String serverId;
    @Component
    protected Settings settings;
    @Component(hint="helper-maven-plugin")
    protected SecDispatcher sec;
    @Component
    protected RedmineService service;
    protected static ShareServerSecretPlugin plugin;
    private static final String REDMINE_USERNAME = "redmine.username";
    private static final String REDMINE_PASSWORD = "redmine.password";
    private static final String REDMINE_API_KEY = "redmine.apiKey";

    protected void init() throws Exception {
        if (plugin == null) {
            plugin = new ShareServerSecretPlugin();
            plugin.setServerId(this.serverId);
            plugin.setUsernameOut(REDMINE_USERNAME);
            plugin.setPasswordOut(REDMINE_PASSWORD);
            plugin.setRunOnce(true);
            plugin.setProject(this.project);
            plugin.setLog(this.getLog());
            plugin.setVerbose(this.isVerbose());
            plugin.setSettings(this.settings);
            plugin.setSec(this.sec);
            plugin.init();
        }
        if (!this.checkLogin) {
            return;
        }
        IssueManagement issueManagement = this.project.getIssueManagement();
        if (issueManagement == null) {
            throw new MojoExecutionException("No Issue Management set.");
        }
        if (issueManagement.getUrl() == null || issueManagement.getUrl().trim().equals("")) {
            throw new MojoExecutionException("No URL set in Issue Management.");
        }
        if (issueManagement.getSystem() != null && !issueManagement.getSystem().equalsIgnoreCase("redmine")) {
            throw new MojoExecutionException("Redmine's Plugin only supports 'redmine' Issue Management system.");
        }
        URL url = this.getRestUrl();
        if (url == null || url.toString().isEmpty()) {
            url = new URL(issueManagement.getUrl());
            if (this.verbose) {
                this.getLog().info((CharSequence)("use the url from issue management : " + url));
            }
        }
        this.setRestUrl(url);
    }

    protected boolean checkSkip() {
        return plugin.checkSkip();
    }

    protected void doAction() throws Exception {
        this.getLog().info((CharSequence)("Obtain redmine login for serverId '" + this.serverId + "'"));
        plugin.setRunOnce(false);
        plugin.execute();
        plugin.setRunOnce(true);
        if (!this.checkLogin) {
            return;
        }
        try {
            ((RedmineServiceImplementor)this.service).init((RedmineServiceConfiguration)this);
            if (!((RedmineServiceImplementor)this.service).isInit()) {
                throw new MojoExecutionException("could not logged to redmine server");
            }
        }
        catch (Exception e) {
            if (this.safe) {
                throw e;
            }
            this.getLog().error((CharSequence)("could not init Redmine service [" + this.getRestUrl() + "] with user '" + this.getRestUsername() + "'"), (Throwable)e);
        }
        this.getLog().info((CharSequence)"Connection to redmine server successfull.");
    }

    protected void afterExecute() {
        RedmineServiceImplementor i;
        if (this.service != null && (i = (RedmineServiceImplementor)this.service).isInit()) {
            try {
                if (this.verbose) {
                    this.getLog().info((CharSequence)"<<< Close redmine rest client...");
                }
                i.destroy();
            }
            catch (Exception ex) {
                this.getLog().error((CharSequence)("could not close redmine client for reason " + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getRestPassword() {
        return this.project.getProperties().getProperty(REDMINE_PASSWORD);
    }

    public URL getRestUrl() {
        return this.url;
    }

    public String getRestUsername() {
        return this.project.getProperties().getProperty(REDMINE_USERNAME);
    }

    public void setRestPassword(String restPassword) {
    }

    public void setRestUrl(URL restUrl) {
        this.url = restUrl;
    }

    public void setRestUsername(String restUsername) {
    }

    public String getEncoding() {
        return null;
    }

    public void setEncoding(String encoding) {
    }

    public boolean isAnonymous() {
        return false;
    }

    public void setAnonymous(boolean anonymous) {
    }

    public boolean isSafe() {
        return this.safe;
    }

    public void setSafe(boolean safe) {
        this.safe = safe;
    }

    public String getApiKey() {
        return this.project.getProperties().getProperty(REDMINE_API_KEY);
    }

    public void setApiKey(String apiKey) {
    }
}

