/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;
import org.nuiton.jredmine.RedmineServiceException;
import org.nuiton.jredmine.model.ModelHelper;
import org.nuiton.jredmine.model.Project;
import org.nuiton.jredmine.model.User;
import org.nuiton.jredmine.plugin.AbstractRedmineMojo;
import org.nuiton.jredmine.plugin.RedmineProjectAware;

public abstract class AbstractRedmineMojoWithProject
extends AbstractRedmineMojo
implements RedmineProjectAware {
    @Parameter(property="redmine.projectId", defaultValue="${project.artifactId}", required=true)
    protected String projectId;
    protected Project releaseProject;
    protected User releaseUser;
    protected User[] users;
    private final boolean requireUser;

    public AbstractRedmineMojoWithProject(boolean requireUser) {
        this.requireUser = requireUser;
    }

    @Override
    protected void init() throws Exception {
        boolean r;
        super.init();
        if (this.initOk && !(r = this.initReleaseProject())) {
            if (this.isSafe()) {
                throw new MojoExecutionException("the project '" + this.projectId + "' could not be retrieve from redmine server.");
            }
            this.initOk = false;
        }
        if (this.initOk && this.requireUser && !(r = this.initReleaseUser())) {
            if (this.isSafe()) {
                throw new MojoExecutionException("the user '" + this.username + "' could not be retrieve from redmine server.");
            }
            this.initOk = false;
        }
    }

    @Override
    protected boolean checkSkip() {
        boolean canContinue = super.checkSkip();
        if (canContinue) {
            if (this.releaseProject == null) {
                this.getLog().error((CharSequence)("the project '" + this.projectId + "' could not be retrieve from redmine server, goal is skip"));
                canContinue = false;
            }
            if (canContinue && this.requireUser && this.releaseUser == null) {
                this.getLog().error((CharSequence)("the user '" + this.username + "' could not be retrieve from redmine server, goal is skip"));
                canContinue = false;
            }
        }
        return canContinue;
    }

    protected boolean initReleaseProject() throws MojoExecutionException {
        if (StringUtils.isBlank((String)this.projectId)) {
            throw new MojoExecutionException("required a projectId parameter");
        }
        try {
            Project p = this.service.getProject(this.projectId);
            if (p == null) {
                return false;
            }
            this.releaseProject = p;
            return true;
        }
        catch (RedmineServiceException e) {
            this.getLog().warn((CharSequence)("could not retreave project '" + this.projectId + "', for reason " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    protected boolean initReleaseUser() throws MojoExecutionException {
        if (StringUtils.isBlank((String)this.username)) {
            throw new MojoExecutionException("required a username parameter");
        }
        try {
            this.users = this.service.getProjectMembers(this.projectId);
            User user = ModelHelper.byLogin((String)this.username, (User[])this.users);
            if (user == null) {
                return false;
            }
            this.releaseUser = user;
            return true;
        }
        catch (RedmineServiceException e) {
            this.getLog().warn((CharSequence)("could not retreave user '" + this.username + "', for reason " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    @Override
    public final String getProjectId() {
        return this.projectId;
    }

    @Override
    public final void setProjectId(String projectId) {
        this.projectId = projectId;
    }
}

