/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.rest;

import java.io.IOException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.util.StringUtils;
import org.nuiton.io.rest.RequestFactory;
import org.nuiton.io.rest.RestClient;
import org.nuiton.io.rest.RestClientConfiguration;
import org.nuiton.io.rest.RestRequest;
import org.nuiton.io.rest.RestSession;
import org.nuiton.jredmine.RedmineServiceConfiguration;
import org.nuiton.jredmine.rest.RedmineRequestFactory;

public class RedmineRestClient
extends RestClient {
    private static final Log log = LogFactory.getLog(RedmineRestClient.class);
    private final RequestFactory requestFactory = new RedmineRequestFactory();

    public RedmineRestClient() {
        this.requestFactory.addDefaultRequests();
    }

    public RedmineRestClient(RestClientConfiguration configuration) {
        super(configuration);
        this.requestFactory.addDefaultRequests();
    }

    public RequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    protected void open(RestSession session) throws IOException {
        this.ping(session);
        if (!this.configuration.isAnonymous()) {
            this.login(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(RestSession session) throws IOException {
        if (session != null) {
            try {
                RestRequest request = this.getRequest("Logout", new Object[0]);
                session.setOpen(false);
                session.doRequest(request);
            }
            finally {
                session.close();
            }
        }
    }

    protected void ping(RestSession session) throws IOException {
        try {
            RestRequest request = this.getRequest("Ping", new Object[0]);
            HttpMethod gm = session.doRequest(request);
            StatusLine sl = gm.getStatusLine();
            int statusCode = sl.getStatusCode();
            if (log.isDebugEnabled()) {
                log.debug((Object)("status code " + statusCode + " for " + gm.getPath()));
            }
            if (statusCode != 200) {
                gm.releaseConnection();
                throw new IOException("Got error code <" + statusCode + ":" + sl.getReasonPhrase() + "> on " + gm.getPath());
            }
            String content = gm.getResponseBodyAsString();
            boolean ok = "ping".equals(content);
            if (!ok) {
                throw new IOException("can not connect to " + this.configuration.getRestUrl());
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException("could not ping " + this.configuration.getRestUrl() + " for reason " + ex.getMessage(), ex);
        }
    }

    protected void login(RestSession session) throws IOException {
        String apiKey = this.getConfiguration().getApiKey();
        boolean useApiKey = StringUtils.isNotBlank((String)apiKey);
        RestRequest request = useApiKey ? this.getRequest("LoginByAPiKey", new Object[]{apiKey}) : this.getRequest("Login", new Object[]{this.configuration.getRestUsername(), this.configuration.getRestPassword()});
        HttpMethod gm = session.doRequest(request);
        StatusLine sl = gm.getStatusLine();
        int statusCode = sl.getStatusCode();
        if (log.isDebugEnabled()) {
            log.debug((Object)("status code " + statusCode + " for " + gm.getPath()));
        }
        if (statusCode != 200) {
            gm.releaseConnection();
            throw new IOException("Got error code <" + statusCode + ":" + sl.getReasonPhrase() + "> on " + gm.getPath());
        }
    }

    public RedmineServiceConfiguration getConfiguration() {
        return (RedmineServiceConfiguration)super.getConfiguration();
    }
}

