/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.model;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.nuiton.jredmine.model.IdAble;
import org.nuiton.jredmine.model.Issue;
import org.nuiton.jredmine.model.User;
import org.nuiton.jredmine.model.Version;

public class ModelHelper {
    public static final String GET_ALL_ISSUE_STATUS_REQUEST_NAME = "IssueStatus/all";
    public static final String GET_ALL_ISSUE_PRIORITY_REQUEST_NAME = "IssuePriority/all";
    public static final String GET_ALL_ISSUE_CATEGORY_REQUEST_NAME = "IssueCategory/all";
    public static final String GET_USER_PROJECTS_REQUEST_NAME = "User/Project/all";
    public static final String GET_ALL_PROJECT_REQUEST_NAME = "Project/all";
    public static final String GET_PROJECT_REQUEST_NAME = "Project/detail";
    public static final String GET_ALL_VERSION_REQUEST_NAME = "Project/Version/all";
    public static final String GET_ALL_TRACKER_REQUEST_NAME = "Project/Tracker/all";
    public static final String GET_ALL_PROJECT_ISSUES_REQUEST_NAME = "Project/Issue/all";
    public static final String GET_ALL_PROJECT_OPENED_ISSUES_REQUEST_NAME = "Project/Issue/opened";
    public static final String GET_ALL_PROJECT_CLOSED_ISSUES_REQUEST_NAME = "Project/Issue/closed";
    public static final String GET_ALL_USER_REQUEST_NAME = "Project/User/all";
    public static final String GET_ALL_NEWS_REQUEST_NAME = "Project/News/all";
    public static final String GET_VERSION_REQUEST_NAME = "Project/Version/detail";
    public static final String GET_ALL_ISSUES_REQUEST_NAME = "Project/Version/Issue/all";
    public static final String GET_ALL_ATTACHMENTS_REQUEST_NAME = "Project/Version/Attachment/all";
    public static final String ADD_ATTACHMENT_REQUEST_NAME = "Project/Version/Attachment/add";
    public static final String ADD_VERSION_REQUEST_NAME = "Project/Version/add";
    public static final String UPDATE_VERSION_REQUEST_NAME = "Project/Version/update";
    public static final String NEXT_VERSION_REQUEST_NAME = "Project/Version/next";
    public static final String ADD_NEWS_REQUEST_NAME = "Project/News/add";
    public static final String GET_ALL_ISSUE_TIME_ENTRY_REQUEST_NAME = "Project/Issue/TimeEntry/all";
    public static final String ADD_ISSUE_TIME_ENTRY_REQUEST_NAME = "Project/Issue/TimeEntry/add";
    public static final String LOGIN_REQUEST_NAME = "Login";
    public static final String LOGIN_BY_API_KEY_REQUEST_NAME = "LoginByAPiKey";
    public static final String LOGOUT_REQUEST_NAME = "Logout";
    public static final String PING_REQUEST_NAME = "Ping";
    public static final String VERSION_SCOPE = "version";
    public static final String PROJECT_SCOPE = "project";
    public static final String ISSUE_SCOPE = "issue";
    public static final Comparator<IdAble> ID_ABLE_COMPARATOR = new Comparator<IdAble>(){

        @Override
        public int compare(IdAble o1, IdAble o2) {
            return o1.getId() - o2.getId();
        }
    };

    public static <T extends IdAble> T byId(int id, T ... datas) {
        for (T data : datas) {
            if (data.getId() != id) continue;
            return data;
        }
        return null;
    }

    public static User byLogin(String login, User ... users) {
        for (User u : users) {
            if (!u.getLogin().equals(login)) continue;
            return u;
        }
        return null;
    }

    public static Version byVersionName(String name, Version ... versions) {
        for (Version u : versions) {
            if (!u.getName().equals(name)) continue;
            return u;
        }
        return null;
    }

    public static Issue[] byTrackerId(int trackerId, Issue ... issues) {
        ArrayList<Issue> result = new ArrayList<Issue>();
        for (Issue i : issues) {
            if (i.getTrackerId() != trackerId) continue;
            result.add(i);
        }
        return result.toArray(new Issue[result.size()]);
    }

    public static Issue[] byVersionId(int versionId, Issue ... issues) {
        ArrayList<Issue> result = new ArrayList<Issue>();
        for (Issue i : issues) {
            if (i.getFixedVersionId() != versionId) continue;
            result.add(i);
        }
        return result.toArray(new Issue[result.size()]);
    }

    public static <T extends IdAble> T[] byIds(Class<T> type, T[] result, Integer ... ids) {
        List<Integer> lIds = Arrays.asList(ids);
        ArrayList<T> filter = new ArrayList<T>(lIds.size());
        for (T v : result) {
            if (!lIds.contains(v.getId())) continue;
            filter.add(v);
        }
        return filter.toArray((IdAble[])Array.newInstance(type, filter.size()));
    }
}

