/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jredmine.DefaultRedmineAnonymousService;
import org.nuiton.jredmine.DefaultRedmineServiceImplementor;
import org.nuiton.jredmine.RedmineAnonymousService;
import org.nuiton.jredmine.RedmineService;
import org.nuiton.jredmine.RedmineServiceConfiguration;
import org.nuiton.jredmine.RedmineServiceException;
import org.nuiton.jredmine.RedmineServiceImplementor;
import org.nuiton.jredmine.model.Attachment;
import org.nuiton.jredmine.model.Issue;
import org.nuiton.jredmine.model.IssueCategory;
import org.nuiton.jredmine.model.IssuePriority;
import org.nuiton.jredmine.model.IssueStatus;
import org.nuiton.jredmine.model.News;
import org.nuiton.jredmine.model.Project;
import org.nuiton.jredmine.model.TimeEntry;
import org.nuiton.jredmine.model.Tracker;
import org.nuiton.jredmine.model.User;
import org.nuiton.jredmine.model.Version;

public class DefaultRedmineService
implements RedmineService {
    protected static final Log log = LogFactory.getLog(DefaultRedmineService.class);
    protected final RedmineServiceImplementor delegateImplementor;
    protected final RedmineAnonymousService anonymousService;

    public DefaultRedmineService() {
        this(new DefaultRedmineServiceImplementor());
    }

    public DefaultRedmineService(RedmineServiceImplementor delegateImplementor) {
        this.delegateImplementor = delegateImplementor;
        this.anonymousService = new DefaultRedmineAnonymousService(delegateImplementor);
    }

    @Override
    public void init(RedmineServiceConfiguration configuration) throws RedmineServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init service with configuration: " + configuration));
        }
        if (!this.delegateImplementor.isInit()) {
            this.delegateImplementor.init(configuration);
        }
    }

    @Override
    public void destroy() throws RedmineServiceException {
        this.delegateImplementor.destroy();
    }

    @Override
    public RedmineServiceImplementor getDelegateImplementor() {
        return this.delegateImplementor;
    }

    @Override
    public IssueStatus[] getIssueStatuses() throws RedmineServiceException {
        IssueStatus[] result = this.anonymousService.getIssueStatuses();
        return result;
    }

    @Override
    public IssuePriority[] getIssuePriorities() throws RedmineServiceException {
        IssuePriority[] result = this.anonymousService.getIssuePriorities();
        return result;
    }

    @Override
    public Project[] getProjects() throws RedmineServiceException {
        Project[] result = this.anonymousService.getProjects();
        return result;
    }

    @Override
    public IssueCategory[] getIssueCategories(String projectName) throws RedmineServiceException {
        IssueCategory[] result = this.anonymousService.getIssueCategories(projectName);
        return result;
    }

    @Override
    public Project getProject(String projectName) throws RedmineServiceException {
        Project result = this.anonymousService.getProject(projectName);
        return result;
    }

    @Override
    public Tracker[] getTrackers(String projectName) throws RedmineServiceException {
        Tracker[] result = this.anonymousService.getTrackers(projectName);
        return result;
    }

    @Override
    public News[] getNews(String projectName) throws RedmineServiceException {
        News[] result = this.anonymousService.getNews(projectName);
        return result;
    }

    @Override
    public User[] getProjectMembers(String projectName) throws RedmineServiceException {
        User[] result = this.anonymousService.getProjectMembers(projectName);
        return result;
    }

    @Override
    public Version[] getVersions(String projectName) throws RedmineServiceException {
        Version[] result = this.anonymousService.getVersions(projectName);
        return result;
    }

    @Override
    public Version getVersion(String projectName, String versionName) throws RedmineServiceException {
        Version result = this.anonymousService.getVersion(projectName, versionName);
        return result;
    }

    @Override
    public Attachment[] getAttachments(String projectName, String versionName) throws RedmineServiceException {
        Attachment[] result = this.anonymousService.getAttachments(projectName, versionName);
        return result;
    }

    @Override
    public Issue[] getIssues(String projectName, String versionName) throws RedmineServiceException {
        Issue[] result = this.anonymousService.getIssues(projectName, versionName);
        return result;
    }

    @Override
    public TimeEntry[] getIssueTimeEntries(String projectName, String issueId) throws RedmineServiceException {
        TimeEntry[] result = this.anonymousService.getIssueTimeEntries(projectName, issueId);
        return result;
    }

    @Override
    public Issue[] getIssues(String projectName) throws RedmineServiceException {
        Issue[] result = this.anonymousService.getIssues(projectName);
        return result;
    }

    @Override
    public Issue[] getOpenedIssues(String projectName) throws RedmineServiceException {
        Issue[] result = this.anonymousService.getOpenedIssues(projectName);
        return result;
    }

    @Override
    public Issue[] getClosedIssues(String projectName) throws RedmineServiceException {
        Issue[] result = this.anonymousService.getClosedIssues(projectName);
        return result;
    }

    @Override
    public Project[] getUserProjects() throws RedmineServiceException {
        this.delegateImplementor.checkLoggued();
        Project[] result = this.delegateImplementor.getDatas("User/Project/all", Project.class, new Object[0]);
        return result;
    }

    @Override
    public Version addVersion(String projectName, Version version) throws RedmineServiceException {
        Version result = this.delegateImplementor.sendData("Project/Version/add", Version.class, projectName, version);
        return result;
    }

    @Override
    public Version updateVersion(String projectName, Version version) throws RedmineServiceException {
        Version result = this.delegateImplementor.sendData("Project/Version/update", Version.class, projectName, version);
        return result;
    }

    @Override
    public Version nextVersion(String projectName, String oldVersionName, Version newVersion) throws RedmineServiceException {
        Version result = this.delegateImplementor.sendData("Project/Version/next", Version.class, projectName, newVersion, oldVersionName);
        return result;
    }

    @Override
    public Attachment addAttachment(String projectName, String versionName, Attachment attachement) throws RedmineServiceException {
        Attachment result = this.delegateImplementor.sendData("Project/Version/Attachment/add", Attachment.class, projectName, versionName, attachement);
        return result;
    }

    @Override
    public News addNews(String projectName, News news) throws RedmineServiceException {
        News result = this.delegateImplementor.sendData("Project/News/add", News.class, projectName, news);
        return result;
    }

    @Override
    public TimeEntry addIssueTimeEntry(String projectName, String issueId, TimeEntry entry) throws RedmineServiceException {
        TimeEntry result = this.delegateImplementor.sendData("Project/Issue/TimeEntry/add", TimeEntry.class, projectName, issueId, entry);
        return result;
    }
}

