/*
 * #%L
 * JRedmine :: Client
 * 
 * $Id: ModelHelper.java 319 2012-07-19 06:50:02Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jredmine/tags/jredmine-1.4/jredmine-client/src/main/java/org/nuiton/jredmine/model/ModelHelper.java $
 * %%
 * Copyright (C) 2009 - 2012 Tony Chemit, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.jredmine.model;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

/**
 * Some usefull methods on redmine's entities, mainly to filter datas.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0.0
 */
public class ModelHelper {

    public static final String GET_ALL_ISSUE_STATUS_REQUEST_NAME = "IssueStatus/all";

    public static final String GET_ALL_ISSUE_PRIORITY_REQUEST_NAME = "IssuePriority/all";

    public static final String GET_ALL_ISSUE_CATEGORY_REQUEST_NAME = "IssueCategory/all";

    public static final String GET_USER_PROJECTS_REQUEST_NAME = "User/Project/all";

    public static final String GET_ALL_PROJECT_REQUEST_NAME = "Project/all";

    public static final String GET_PROJECT_REQUEST_NAME = "Project/detail";

    public static final String GET_ALL_VERSION_REQUEST_NAME = "Project/Version/all";

    public static final String GET_ALL_TRACKER_REQUEST_NAME = "Project/Tracker/all";

    public static final String GET_ALL_PROJECT_ISSUES_REQUEST_NAME = "Project/Issue/all";

    public static final String GET_ALL_PROJECT_OPENED_ISSUES_REQUEST_NAME = "Project/Issue/opened";

    public static final String GET_ALL_PROJECT_CLOSED_ISSUES_REQUEST_NAME = "Project/Issue/closed";

    public static final String GET_ALL_USER_REQUEST_NAME = "Project/User/all";

    public static final String GET_ALL_NEWS_REQUEST_NAME = "Project/News/all";

    public static final String GET_VERSION_REQUEST_NAME = "Project/Version/detail";

    public static final String GET_ALL_ISSUES_REQUEST_NAME = "Project/Version/Issue/all";

    public static final String GET_ALL_ATTACHMENTS_REQUEST_NAME = "Project/Version/Attachment/all";

    public static final String ADD_ATTACHMENT_REQUEST_NAME = "Project/Version/Attachment/add";

    public static final String ADD_VERSION_REQUEST_NAME = "Project/Version/add";

    public static final String UPDATE_VERSION_REQUEST_NAME = "Project/Version/update";

    public static final String NEXT_VERSION_REQUEST_NAME = "Project/Version/next";

    public static final String ADD_NEWS_REQUEST_NAME = "Project/News/add";

    public static final String GET_ALL_ISSUE_TIME_ENTRY_REQUEST_NAME = "Project/Issue/TimeEntry/all";

    public static final String ADD_ISSUE_TIME_ENTRY_REQUEST_NAME = "Project/Issue/TimeEntry/add";

    public static final String LOGIN_REQUEST_NAME = "Login";

    public static final String LOGIN_BY_API_KEY_REQUEST_NAME = "LoginByAPiKey";

    public static final String LOGOUT_REQUEST_NAME = "Logout";

    public static final String PING_REQUEST_NAME = "Ping";

    public static final String VERSION_SCOPE = "version";

    public static final String PROJECT_SCOPE = "project";

    public static final String ISSUE_SCOPE = "issue";

    public static <T extends IdAble> T byId(int id, T... datas) {
        for (T data : datas) {
            if (data.getId() == id) {
                return data;
            }
        }
        return null;
    }

    public static User byLogin(String login, User... users) {
        for (User u : users) {
            if (u.getLogin().equals(login)) {
                return u;
            }
        }
        return null;
    }

    public static Version byVersionName(String name, Version... versions) {
        for (Version u : versions) {
            if (u.getName().equals(name)) {
                return u;
            }
        }
        return null;
    }

    public static Issue[] byTrackerId(int trackerId, Issue... issues) {
        List<Issue> result = new ArrayList<Issue>();
        for (Issue i : issues) {
            if (i.getTrackerId() == trackerId) {
                result.add(i);
            }
        }
        return result.toArray(new Issue[result.size()]);
    }

    public static Issue[] byVersionId(int versionId, Issue... issues) {
        List<Issue> result = new ArrayList<Issue>();
        for (Issue i : issues) {
            if (i.getFixedVersionId() == versionId) {
                result.add(i);
            }
        }
        return result.toArray(new Issue[result.size()]);
    }

    public static <T extends IdAble> T[] byIds(Class<T> type, T[] result, Integer... ids) {

        List<Integer> lIds = Arrays.asList(ids);
        List<T> filter = new ArrayList<T>(lIds.size());
        for (T v : result) {
            if (lIds.contains(v.getId())) {
                filter.add(v);
            }
        }
        return filter.toArray((T[]) Array.newInstance(type, filter.size()));
    }

    public static final Comparator<IdAble> ID_ABLE_COMPARATOR = new Comparator<IdAble>() {

        @Override
        public int compare(IdAble o1, IdAble o2) {
            return o1.getId() - o2.getId();
        }
    };
}
