/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jpa.hibernate;

import java.io.File;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.h2.Driver;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.ejb.EntityManagerFactoryImpl;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.internal.SessionFactoryServiceRegistryImpl;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.tool.hbm2ddl.SchemaExport;

public class HibernateUtil {
    private static final Log log = LogFactory.getLog(HibernateUtil.class);
    protected static final Map<String, String> HIBERNATE_H2_CONFIG;
    public static final String HBM2DDL_AUTO_VALIDATE = "validate";
    public static final String HBM2DDL_AUTO_CREATE_DROP = "create-drop";
    public static final String HBM2DDL_AUTO_CREATE = "create";
    public static final String HBM2DDL_AUTO_UPDATE = "update";

    private HibernateUtil() {
    }

    public static EntityManagerFactory createTempEntityManagerFactory(String persistenceUnitName, String context) {
        EntityManagerFactory tempEntityManagerFactory = HibernateUtil.createTempEntityManagerFactory(persistenceUnitName, context, Collections.<String, String>emptyMap());
        return tempEntityManagerFactory;
    }

    public static EntityManagerFactory createTempEntityManagerFactory(String persistenceUnitName, String context, Map<String, String> jpaParameters) {
        HashMap<String, String> allJpaParameters = new HashMap<String, String>();
        allJpaParameters.putAll(jpaParameters);
        allJpaParameters.putAll(HIBERNATE_H2_CONFIG);
        File tempDirFile = SystemUtils.getJavaIoTmpDir();
        File databaseFile = new File(tempDirFile, context);
        String h2dataPath = databaseFile.getAbsolutePath() + File.separator + "h2data";
        String jdbcUrl = "jdbc:h2:file:" + h2dataPath;
        allJpaParameters.put("javax.persistence.jdbc.url", jdbcUrl);
        if (log.isTraceEnabled()) {
            log.trace((Object)("will store H2 data in " + h2dataPath));
            log.trace((Object)("allJpaParameters = " + allJpaParameters));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("jdbc url is\n" + jdbcUrl));
        }
        EntityManagerFactory entityManagerFactory = Persistence.createEntityManagerFactory((String)persistenceUnitName, allJpaParameters);
        return entityManagerFactory;
    }

    public static void cleanDatabase(EntityManager entityManager) {
        Configuration configuration;
        ServiceRegistryImplementor serviceRegistry;
        block5: {
            if (log.isInfoEnabled()) {
                log.info((Object)"will clean database");
            }
            serviceRegistry = ((EntityManagerFactoryImpl)entityManager.getEntityManagerFactory()).getSessionFactory().getServiceRegistry();
            configuration = null;
            try {
                Field configurationField = SessionFactoryServiceRegistryImpl.class.getDeclaredField("configuration");
                configurationField.setAccessible(true);
                configuration = (Configuration)configurationField.get(serviceRegistry);
            }
            catch (IllegalAccessException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"should not occur", (Throwable)e);
                }
            }
            catch (NoSuchFieldException e) {
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)"should not occur", (Throwable)e);
            }
        }
        SchemaExport schemaExport = new SchemaExport((ServiceRegistry)serviceRegistry, configuration);
        schemaExport.setHaltOnError(true);
        schemaExport.execute(true, true, true, false);
        schemaExport.execute(true, true, false, true);
    }

    static {
        HashMap<String, String> hibernateH2Config = new HashMap<String, String>();
        hibernateH2Config.put("javax.persistence.jdbc.driver", Driver.class.getName());
        hibernateH2Config.put("javax.persistence.jdbc.user", "sa");
        hibernateH2Config.put("javax.persistence.jdbc.password", "");
        hibernateH2Config.put("hibernate.dialect", H2Dialect.class.getName());
        hibernateH2Config.put("hibernate.hbm2ddl.auto", HBM2DDL_AUTO_UPDATE);
        HIBERNATE_H2_CONFIG = Collections.unmodifiableMap(hibernateH2Config);
    }
}

