/*
 * #%L
 * JAXX :: Widgets
 * %%
 * Copyright (C) 2008 - 2014 Code Lutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.Icon;
import javax.swing.JComponent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

/**
 * Handler of ui {@link HidorButton}.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 2.0
 */
public class HidorButtonHandler {

    private static final Log log =
            LogFactory.getLog(HidorButtonHandler.class);

    protected final HidorButton ui;

    public HidorButtonHandler(HidorButton ui) {
        this.ui = ui;
    }

    void $afterCompleteSetup() {

        ui.addPropertyChangeListener("targetVisible", new PropertyChangeListener() {

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (log.isDebugEnabled()) {
                    log.debug("target visible changed <" + evt.getOldValue() + ":" + evt.getNewValue() + ">");
                }
                boolean newValue = (Boolean) evt.getNewValue();
                if (ui.target != null) {
                    ui.target.setVisible(newValue);
                }
            }
        });
    }

    public void setTarget(JComponent target) {
        JComponent oldValue = ui.target;
        ui.target = target;
        ui.firePropertyChange("target", oldValue, target);
    }

    public void setExpandIcon(Icon icon) {
        ui.putClientProperty("expandIcon", icon);
    }

    public void setHideIcon(Icon icon) {
        ui.putClientProperty("hideIcon", icon);
    }

    protected String updateToolTipText(boolean c) {
        return c ? ui.hideTip : ui.showTip;
    }

    protected String updateText(boolean c) {
        return c ? ui.hideText : ui.showText;
    }

    protected Icon updateIcon(boolean c) {
        String key = c ? "hideIcon" : "showIcon";
        return (Icon) ui.getClientProperty(key);
    }
}
