/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.gis.signed;

import com.google.common.base.Preconditions;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatterFactory;
import jaxx.runtime.spi.UIHandler;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.gis.DmsCoordinate;
import org.nuiton.jaxx.widgets.gis.DmsCoordinateConverter;
import org.nuiton.jaxx.widgets.gis.MaskFormatterFromConverter;
import org.nuiton.jaxx.widgets.gis.signed.SignedDmsCoordinateEditor;
import org.nuiton.jaxx.widgets.gis.signed.SignedDmsCoordinateEditorModel;
import org.nuiton.util.beans.BeanUtil;

public class SignedDmsCoordinateEditorHandler
implements UIHandler<SignedDmsCoordinateEditor> {
    private static final Log log = LogFactory.getLog(SignedDmsCoordinateEditorHandler.class);
    protected SignedDmsCoordinateEditor ui;
    protected Method signMutator;
    protected Method degreMutator;
    protected Method minuteMutator;
    protected Method secondMutator;
    protected boolean valueIsAdjusting;
    protected boolean valueModelIsAdjusting;
    protected DmsCoordinateConverter signedConverter;
    protected DmsCoordinateConverter unsignedConverter;
    protected DefaultFormatterFactory signedFormatterFactory;
    protected DefaultFormatterFactory unsignedFormatterFactory;

    public void beforeInit(SignedDmsCoordinateEditor ui) {
        this.ui = ui;
        this.signedConverter = new DmsCoordinateConverter();
        this.signedConverter.setUseSign(true);
        this.unsignedConverter = new DmsCoordinateConverter();
    }

    public void afterInit(SignedDmsCoordinateEditor ui) {
    }

    public void init(boolean longitudeEditor) {
        MaskFormatterFromConverter<DmsCoordinate> maskFormatter;
        final SignedDmsCoordinateEditorModel model = this.ui.getModel();
        Preconditions.checkNotNull((Object)model.getBean(), (Object)("could not find bean in " + this.ui));
        Preconditions.checkNotNull((Object)model.getPropertySign(), (Object)("could not find propertySign in " + this.ui));
        Preconditions.checkNotNull((Object)model.getPropertyDegree(), (Object)("could not find propertyDegree in " + this.ui));
        Preconditions.checkNotNull((Object)model.getPropertyMinute(), (Object)("could not find propertyMinute in " + this.ui));
        Preconditions.checkNotNull((Object)model.getPropertySecond(), (Object)("could not find propertySecond in " + this.ui));
        Serializable bean = model.getBean();
        this.signMutator = BeanUtil.getMutator((Object)bean, (String)model.getPropertySign());
        Preconditions.checkNotNull((Object)this.signMutator, (Object)("could not find mutator for " + model.getPropertySign()));
        this.degreMutator = BeanUtil.getMutator((Object)bean, (String)model.getPropertyDegree());
        Preconditions.checkNotNull((Object)this.degreMutator, (Object)("could not find mutator for " + model.getPropertyDegree()));
        this.minuteMutator = BeanUtil.getMutator((Object)bean, (String)model.getPropertyMinute());
        Preconditions.checkNotNull((Object)this.minuteMutator, (Object)("could not find mutator for " + model.getPropertyMinute()));
        this.secondMutator = BeanUtil.getMutator((Object)bean, (String)model.getPropertySecond());
        Preconditions.checkNotNull((Object)this.secondMutator, (Object)("could not find mutator for " + model.getPropertySecond()));
        this.signedConverter.setForLongitude(longitudeEditor);
        this.unsignedConverter.setForLongitude(longitudeEditor);
        String pattern = this.getMaskFormatterPattern(longitudeEditor, false);
        try {
            maskFormatter = MaskFormatterFromConverter.newFormatter(DmsCoordinate.class, pattern, (Converter)this.unsignedConverter);
            maskFormatter.setValidCharacters(" 01234567890");
            maskFormatter.setCommitsOnValidEdit(true);
            this.unsignedFormatterFactory = new DefaultFormatterFactory(maskFormatter);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        pattern = this.getMaskFormatterPattern(longitudeEditor, true);
        try {
            maskFormatter = MaskFormatterFromConverter.newFormatter(DmsCoordinate.class, pattern, (Converter)this.signedConverter);
            maskFormatter.setValidCharacters(" 01234567890");
            maskFormatter.setCommitsOnValidEdit(true);
            this.signedFormatterFactory = new DefaultFormatterFactory(maskFormatter);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        JFormattedTextField editor = this.ui.getEditor();
        editor.setFormatterFactory(model.isSign() ? this.signedFormatterFactory : this.unsignedFormatterFactory);
        editor.setFocusLostBehavior(0);
        editor.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DmsCoordinate newValue = (DmsCoordinate)((Object)evt.getNewValue());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Value has changed: " + (Object)((Object)newValue)));
                }
                model.setValue(newValue);
            }
        });
        model.addPropertyChangeListener("sign", new ModelPropertyChangeListener(model, this.signMutator));
        model.addPropertyChangeListener("degree", new ModelPropertyChangeListener(model, this.degreMutator));
        model.addPropertyChangeListener("minute", new ModelPropertyChangeListener(model, this.minuteMutator));
        model.addPropertyChangeListener("second", new ModelPropertyChangeListener(model, this.secondMutator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(DmsCoordinate value, boolean pushToModel) {
        if (this.valueModelIsAdjusting) {
            return;
        }
        this.valueIsAdjusting = !pushToModel;
        try {
            this.ui.getEditor().setValue((Object)value);
        }
        finally {
            this.valueIsAdjusting = false;
        }
    }

    public void resetEditor() {
        this.setValue(null, true);
        this.ui.getEditor().setFormatterFactory(this.unsignedFormatterFactory);
    }

    public void onKeyReleased(KeyEvent e) {
        JFormattedTextField source = (JFormattedTextField)e.getSource();
        char keyChar = e.getKeyChar();
        int caretPosition = source.getCaretPosition();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Key pressed: " + keyChar + " (caret position: " + caretPosition + ")"));
        }
        if (keyChar == '-') {
            DefaultFormatterFactory newFactory;
            DmsCoordinate value = (DmsCoordinate)((Object)source.getValue());
            boolean useSign = this.ui.getModel().isSign();
            if (useSign) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Switch to unsigned");
                }
                newFactory = this.unsignedFormatterFactory;
                --caretPosition;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Switch to signed");
                }
                newFactory = this.signedFormatterFactory;
                ++caretPosition;
            }
            DmsCoordinate newValue = DmsCoordinate.valueOf(value);
            newValue.setSign(!useSign);
            source.setFormatterFactory(newFactory);
            source.setValue((Object)newValue);
            e.consume();
            source.setCaretPosition(caretPosition);
        }
    }

    protected String getMaskFormatterPattern(boolean longitudeEditor, boolean useSign) {
        String pattern = "**\u00b0**''**''''";
        if (longitudeEditor) {
            pattern = "*" + pattern;
        }
        if (useSign) {
            pattern = "-" + pattern;
        }
        return pattern;
    }

    private class ModelPropertyChangeListener
    implements PropertyChangeListener {
        private final SignedDmsCoordinateEditorModel model;
        private final Method mutator;

        private ModelPropertyChangeListener(SignedDmsCoordinateEditorModel model, Method mutator) {
            this.model = model;
            this.mutator = mutator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!SignedDmsCoordinateEditorHandler.this.valueIsAdjusting) {
                Object newValue = evt.getNewValue();
                try {
                    SignedDmsCoordinateEditorHandler.this.valueModelIsAdjusting = true;
                    try {
                        this.mutator.invoke((Object)this.model.getBean(), newValue);
                    }
                    finally {
                        SignedDmsCoordinateEditorHandler.this.valueModelIsAdjusting = false;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

