/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.regex.Pattern;
import jaxx.runtime.validator.BeanValidator;
import jaxx.runtime.validator.BeanValidatorDetector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractBeanValidatorDetectorTest {
    private static final Log log = LogFactory.getLog(AbstractBeanValidatorDetectorTest.class);
    protected static File basedir;
    protected BeanValidatorDetector instance;
    protected Class<?>[] classes;
    protected Class<?> validatorClass;
    protected File sourceRoot;

    protected AbstractBeanValidatorDetectorTest(File sourceRoot, Class<?> ... classes) {
        this(BeanValidator.class, sourceRoot, classes);
    }

    protected AbstractBeanValidatorDetectorTest(Class<?> validatorClass, File sourceRoot, Class<?> ... classes) {
        this.sourceRoot = sourceRoot;
        this.classes = classes;
        this.validatorClass = validatorClass;
        log.info((Object)("sourceRoot     " + sourceRoot));
        log.info((Object)("validatorClass " + validatorClass));
        log.info((Object)("classes        " + Arrays.toString(classes)));
    }

    protected AbstractBeanValidatorDetectorTest(File sourceRoot, Collection<Class<?>> classes) {
        this(sourceRoot, classes.toArray(new Class[classes.size()]));
    }

    public static void setUpClass() throws Exception {
        String b = System.getenv("basedir");
        if (b == null) {
            b = new File("").getAbsolutePath();
        }
        basedir = new File(b);
        log.info((Object)("basedir  " + basedir));
    }

    @Before
    public void setUp() {
        this.instance = new BeanValidatorDetector();
    }

    @After
    public void tearDown() {
        this.instance = null;
    }

    @Test
    public void testDetect() {
        SortedSet<BeanValidator<?>> result = this.detect(this.sourceRoot, this.classes, null);
        log.info((Object)AbstractBeanValidatorDetectorTest.printValidators("testDetect : ", result));
        this.assertDetect(result);
    }

    protected abstract void assertDetect(SortedSet<BeanValidator<?>> var1);

    protected SortedSet<BeanValidator<?>> detect(File sourceRoot, Class<?>[] classes, Pattern contextPattern) {
        SortedSet result = this.instance.detect(this.validatorClass, sourceRoot, contextPattern, (Class[])classes);
        return result;
    }

    protected static void assertValidator(Class<?> expectedBeanClass, String expectedContextName, BeanValidator<?> validator) {
        Assert.assertEquals(expectedBeanClass, (Object)validator.getBeanClass());
        Assert.assertEquals((Object)expectedContextName, (Object)validator.getContextName());
    }

    protected static void assertValidatorSetWithSameContextName(SortedSet<BeanValidator<?>> validators, String contextName, Class<?> ... expectedClasses) {
        Assert.assertEquals((long)expectedClasses.length, (long)validators.size());
        Iterator itrV = validators.iterator();
        for (Class<?> expectedClass : expectedClasses) {
            AbstractBeanValidatorDetectorTest.assertValidator(expectedClass, contextName, (BeanValidator)itrV.next());
        }
    }

    protected static void assertValidatorSetWithMultiContextName(SortedSet<BeanValidator<?>> validators, Object ... expecteds) {
        Assert.assertEquals((long)(expecteds.length % 2), (long)0L);
        Assert.assertEquals((long)(expecteds.length / 2), (long)validators.size());
        Iterator itrV = validators.iterator();
        for (int i = 0; i < expecteds.length / 2; ++i) {
            String contextName = (String)expecteds[2 * i];
            Class expectedClass = (Class)expecteds[2 * i + 1];
            AbstractBeanValidatorDetectorTest.assertValidator(expectedClass, contextName, (BeanValidator)itrV.next());
        }
    }

    protected static String printValidators(String prefix, SortedSet<BeanValidator<?>> result) {
        StringBuilder buffer = new StringBuilder(result.size() * (prefix.length() + 50));
        buffer.append(prefix).append(result.size()).append('\n');
        for (BeanValidator beanValidator : result) {
            buffer.append(prefix).append(beanValidator).append('\n');
        }
        return buffer.toString();
    }
}

