package jaxx.runtime.swing.navigation;

import jaxx.runtime.Decorator;
import jaxx.runtime.JAXXAction;
import jaxx.runtime.JAXXContextEntryDef;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.navigation.NavigationTreeModel.NavigationTreeNode;
import jaxx.runtime.swing.navigation.NavigationUtil.NodeRenderer;

/** @author chemit */
public class NavigationTreeModelBuilder {

    protected NavigationTreeModel model;

    public NavigationTreeModelBuilder(String navigationSeparator) {
        model = new NavigationTreeModel(null, navigationSeparator);
    }

    public NavigationTreeModel getModel() {
        return model;
    }

    public NavigationTreeNode build(NavigationTreeNode parentNode, String libelle,
                                    JAXXContextEntryDef entryDef,
                                    String entryPath,
                                    String contextName,
                                    Class<? extends JAXXObject> uiClass,
                                    Class<? extends JAXXAction> actionClass) {
        NavigationTreeNode node = model.new NavigationTreeNode(new NodeRenderer(libelle), entryDef, entryPath, contextName, uiClass, actionClass);
        return addChildNode(parentNode, node);
    }

    public NavigationTreeNode build(NavigationTreeNode parentNode, String libelle,
                                    JAXXContextEntryDef entryDef,
                                    String contextName,
                                    Class<? extends JAXXObject> uiClass,
                                    Class<? extends JAXXAction> actionClass) {
        NavigationTreeNode node = model.new NavigationTreeNode(new NodeRenderer(libelle), entryDef, contextName, uiClass, actionClass);
        return addChildNode(parentNode, node);
    }

    public NavigationTreeNode build(NavigationTreeNode parentNode, String libelle,
                                    String entryPath,
                                    String contextName,
                                    Class<? extends JAXXObject> uiClass,
                                    Class<? extends JAXXAction> actionClass) {
        NavigationTreeNode node = model.new NavigationTreeNode(new NodeRenderer(libelle), entryPath, contextName, uiClass, actionClass);
        return addChildNode(parentNode, node);
    }

    public NavigationTreeNode build(NavigationTreeNode parentNode, Decorator<?> decorator,
                                    JAXXContextEntryDef entryDef,
                                    String entryPath,
                                    String contextName,
                                    Class<? extends JAXXObject> uiClass,
                                    Class<? extends JAXXAction> actionClass) {
        NavigationTreeNode node = model.new NavigationTreeNode(new NodeRenderer(decorator), entryDef, entryPath, contextName, uiClass, actionClass);
        return addChildNode(parentNode, node);
    }

    public NavigationTreeNode build(NavigationTreeNode parentNode, Decorator<?> decorator,
                                    JAXXContextEntryDef entryDef,
                                    String contextName,
                                    Class<? extends JAXXObject> uiClass,
                                    Class<? extends JAXXAction> actionClass) {
        NavigationTreeNode node = model.new NavigationTreeNode(new NodeRenderer(decorator), entryDef, contextName, uiClass, actionClass);
        return addChildNode(parentNode, node);
    }

    public NavigationTreeNode build(NavigationTreeNode parentNode, Decorator<?> decorator,
                                    String entryPath,
                                    String contextName,
                                    Class<? extends JAXXObject> uiClass,
                                    Class<? extends JAXXAction> actionClass) {
        NavigationTreeNode node = model.new NavigationTreeNode(new NodeRenderer(decorator), entryPath, contextName, uiClass, actionClass);
        return addChildNode(parentNode, node);
    }

    protected NavigationTreeNode addChildNode(NavigationTreeNode parentNode, NavigationTreeNode node) {
        if (parentNode == null) {
            model.setRoot(node);
        } else {
            parentNode.add(node);
        }
        model.nodeStructureChanged(parentNode);
        return node;
    }

    public NavigationTreeNode removeChildNode(NavigationTreeNode node) {
        NavigationTreeNode parentNode = node.getParent();
        model.removeNodeFromParent(node);
        return parentNode;
    }

    public static abstract class ChildBuilder<O> {

        protected NavigationTreeModelBuilder builder;

        protected ChildBuilder(NavigationTreeModelBuilder builder) {
            this.builder = builder;
        }

        protected abstract void init(Class<? extends O> klass);

        protected abstract Decorator<? extends O> getDecorator(O child);

        protected abstract String getJXPath(O child);

        protected abstract String getNavigationPath(O child);

        public void build(NavigationTreeNode parent, boolean cacheValues, Class<? extends O> klass, java.util.Collection<? extends O> beans, Class<? extends JAXXObject> ui, Class<? extends JAXXAction> actionClass) {

            if (beans == null || beans.isEmpty()) {
                // no bean to treate
                return;
            }

            init(klass);

            NavigationTreeNode node;

            for (O o : beans) {
                node = builder.build(parent, getDecorator(o), getJXPath(o), getNavigationPath(o), ui, actionClass);
                if (cacheValues) {
                    // cache the bean value to improve performance
                    node.setCachedBean(o);
                }
            }
        }

        public void build(NavigationTreeNode parent, boolean cacheValues, Class<? extends O> klass, O[] beans, Class<? extends JAXXObject> ui, Class<? extends JAXXAction> actionClass) {

            if (beans == null || beans.length == 0) {
                // no bean to treate
                return;
            }

            init(klass);

            NavigationTreeNode node;

            for (O o : beans) {
                node = builder.build(parent, getDecorator(o), getJXPath(o), getNavigationPath(o), ui, actionClass);
                if (cacheValues) {
                    // cache the bean value to improve performance
                    node.setCachedBean(o);
                }
            }
        }
    }

}
