package jaxx.runtime.swing;

import java.awt.Component;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 *
 * @author chemit
 */
public class LocaleListCellRenderer extends DefaultListCellRenderer {

    public static final Log log = LogFactory.getLog(LocaleListCellRenderer.class);
    private static final long serialVersionUID = 1L;
    protected Map<Locale, Icon> cache = new HashMap<Locale, Icon>();
    protected boolean showIcon;
    protected boolean showText;

    public LocaleListCellRenderer() {
        this(true, true);
    }

    public LocaleListCellRenderer(boolean showIcon, boolean showText) {
        this.showIcon = showIcon;
        this.showText = showText;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel comp = (JLabel) super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        Locale locale = (Locale) value;
        if (locale != null) {
            Icon icon = getIcon(locale);
            comp.setIcon(icon);
        }
        String text = getText(locale);
        String tip = getToolTipText(locale);
        comp.setText(text);
        comp.setToolTipText(tip);
        return comp;
    }

    public String getText(Locale locale) {
        String text = null;
        if (showText) {
            text = locale.getDisplayName(Locale.getDefault());
        }
        return text;
    }

    public String getToolTipText(Locale locale) {
        String tip = locale.getDisplayName(Locale.getDefault());
        return tip;
    }

    public boolean isShowText() {
        return showText;
    }

    public boolean isShowIcon() {
        return showIcon;
    }

    public void setShowIcon(boolean showIcon) {
        boolean old = this.showIcon;
        this.showIcon = showIcon;
        firePropertyChange("showIcon", old, showIcon);
    }

    public void setShowText(boolean showText) {
        boolean old = this.showText;
        this.showText = showText;
        firePropertyChange("showText", old, showText);
    }

    public synchronized Icon getIcon(Locale locale) {
        if (!showIcon) {
            return null;
        }
        Icon icon = cache.get(locale);
        if (icon != null) {
            return icon;
        }

        icon = SwingUtil.getUIManagerActionIcon("i18n-" + locale.toString());

        if (icon == null) {
            log.warn("could not find icon action.i18n-" + locale.toString());
            if (locale.getCountry() != null) {
                icon = SwingUtil.getUIManagerActionIcon("i18n-" + locale.getCountry().toLowerCase());
                if (icon == null) {
                    log.warn("could not find icon action.i18n-" + locale.getCountry().toLowerCase());

                    icon = SwingUtil.createActionIcon("i18n-" + locale.getCountry().toLowerCase());
                    if (icon == null) {
                        log.warn("could not find icon action.i18n-" + locale.getCountry().toLowerCase());
                    }
                }

            }
        }

        cache.put(locale, icon);
        return icon;
    }
}
