/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.editor.config.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import jaxx.runtime.swing.editor.config.model.CategoryModel;
import jaxx.runtime.swing.editor.config.model.OptionModel;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;

public class ConfigUIModel
implements Iterable<CategoryModel> {
    public static final String CATEGORY_MODEL_PROPERTY_NAME = "categoryModel";
    protected final Map<String, CategoryModel> categories;
    protected final ApplicationConfig config;
    protected CategoryModel categoryModel;
    protected boolean saved;
    protected boolean standalone;
    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public ConfigUIModel(ApplicationConfig config) {
        this.config = config;
        this.categories = new LinkedHashMap<String, CategoryModel>();
    }

    public void addCategory(String category, String categoryLabel, ApplicationConfig.OptionDef ... keys) {
        if (this.categories.containsKey(category)) {
            throw new IllegalArgumentException(I18n._((String)"config.error.category.already.exists", (Object[])new Object[]{category}));
        }
        OptionModel[] entries = new OptionModel[keys.length];
        int index = 0;
        for (ApplicationConfig.OptionDef d : keys) {
            Object value = this.config.getOption(d);
            OptionModel e = new OptionModel(d, value);
            entries[index++] = e;
        }
        CategoryModel m = new CategoryModel(category, categoryLabel, entries);
        this.categories.put(category, m);
    }

    public void setCategory(String category) {
        if (!this.categories.containsKey(category)) {
            throw new IllegalArgumentException(I18n._((String)"config.error.category.not.found", (Object[])new Object[]{category}));
        }
        CategoryModel newCategoryModel = this.categories.get(category);
        this.setCategoryModel(newCategoryModel);
        newCategoryModel.firePropertyChange("modified", false, this.getCategoryModel().isModified());
        newCategoryModel.firePropertyChange("valid", false, this.getCategoryModel().isValid());
    }

    @Override
    public Iterator<CategoryModel> iterator() {
        return this.categories.values().iterator();
    }

    public CategoryModel getCategoryModel() {
        return this.categoryModel;
    }

    public void setCategoryModel(CategoryModel categoryModel) {
        CategoryModel old = this.categoryModel;
        this.categoryModel = categoryModel;
        this.firePropertyChange(CATEGORY_MODEL_PROPERTY_NAME, old, categoryModel);
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setSaved(boolean saved) {
        this.saved = saved;
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    public void saveModified() {
        ArrayList<String> transients = new ArrayList<String>();
        for (OptionModel option : this.categoryModel) {
            if (option.isModified()) {
                Object value = option.getValue();
                this.config.setOption(option.getKey(), value == null ? null : value.toString());
                option.setSaved(true);
                option.initValue(value);
            }
            if (!option.isTransient()) continue;
            transients.add(option.getKey());
        }
        this.setSaved(true);
        this.config.saveForUser(transients.toArray(new String[transients.size()]));
        this.categoryModel.firePropertyChange("modified", this.categoryModel.isModified(), true);
        this.categoryModel.firePropertyChange("valid", false, this.categoryModel.isValid());
        this.categoryModel.firePropertyChange("reload", false, true);
    }

    public void reset() {
        for (OptionModel key : this.categoryModel) {
            if (!key.isModified()) continue;
            key.initValue(key.getOriginalValue());
        }
        this.categoryModel.firePropertyChange("modified", this.categoryModel.isModified(), true);
        this.categoryModel.firePropertyChange("valid", false, this.categoryModel.isValid());
        this.categoryModel.firePropertyChange("reload", false, true);
    }

    public int getCategoryIndex(String category) {
        int i = 0;
        for (CategoryModel m : this) {
            if (category.equals(m.getCategory())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public synchronized boolean hasListeners(String propertyName) {
        return this.pcs.hasListeners(propertyName);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.pcs.getPropertyChangeListeners(propertyName);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }
}

