/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.api.internal.binding;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.runtime.api.JAXXObject;
import org.nuiton.jaxx.runtime.api.internal.binding.DataBindingListener;
import org.nuiton.jaxx.runtime.api.internal.binding.DataBindingUpdateListener;
import org.nuiton.jaxx.runtime.api.internal.binding.JAXXBinding;

public class JAXXBindings {
    private static final Log log = LogFactory.getLog(JAXXBindings.class);
    private static final PropertyChangeListener[] EMPTY_ARRAY_PROPERTY_CHANGE_LISTENERS = new PropertyChangeListener[0];
    private static final Map<JAXXObject, WeakReference<List<DataBindingUpdateListener>>> dataBindingUpdateListeners = new WeakHashMap<JAXXObject, WeakReference<List<DataBindingUpdateListener>>>();

    public static void reloadBinding(JAXXBinding binding) {
        binding.removeDataBinding();
        binding.applyDataBinding();
    }

    public static void reloadBinding(JAXXObject src, String bindingId) {
        JAXXBinding dataBinding = src.getDataBinding(bindingId);
        if (dataBinding != null) {
            JAXXBindings.reloadBinding(dataBinding);
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Could not found binding[" + bindingId + "] on ui " + src));
        }
    }

    public static void applyDataBinding(JAXXObject src, String ... bindings) {
        for (String binding : bindings) {
            src.applyDataBinding(binding);
        }
    }

    public static void applyDataBinding(JAXXObject src, Collection<String> bindings) {
        for (String binding : bindings) {
            src.applyDataBinding(binding);
        }
    }

    public static void processDataBinding(JAXXObject src, String ... bindings) {
        for (String binding : bindings) {
            src.processDataBinding(binding);
        }
    }

    public static void removeDataBinding(JAXXObject src, String ... bindings) {
        for (String binding : bindings) {
            src.removeDataBinding(binding);
        }
    }

    public static void removeAllDataBindings(JAXXObject src) {
        JAXXBinding[] bindings;
        for (JAXXBinding binding : bindings = src.getDataBindings()) {
            JAXXBindings.removeDataBinding(src, binding.getId());
        }
    }

    public static DataBindingUpdateListener getDataBindingUpdateListener(JAXXObject object, String bindingName) {
        ArrayList<DataBindingUpdateListener> listeners;
        WeakReference<List<DataBindingUpdateListener>> ref = dataBindingUpdateListeners.get(object);
        ArrayList<DataBindingUpdateListener> arrayList = listeners = ref == null ? null : (ArrayList<DataBindingUpdateListener>)ref.get();
        if (listeners == null) {
            listeners = new ArrayList<DataBindingUpdateListener>();
            dataBindingUpdateListeners.put(object, new WeakReference(listeners));
        } else {
            for (DataBindingUpdateListener listener : listeners) {
                if (!bindingName.equals(listener.getBindingName())) continue;
                return listener;
            }
        }
        DataBindingUpdateListener listener = new DataBindingUpdateListener(object, bindingName);
        listeners.add(listener);
        return listener;
    }

    public static PropertyChangeListener[] findJaxxPropertyChangeListener(String[] propertyNames, PropertyChangeListener ... listeners) {
        if (listeners == null || listeners.length == 0) {
            return EMPTY_ARRAY_PROPERTY_CHANGE_LISTENERS;
        }
        List<String> pNames = Arrays.asList(propertyNames);
        ArrayList<PropertyChangeListenerProxy> toRemove = new ArrayList<PropertyChangeListenerProxy>();
        for (PropertyChangeListener listener : listeners) {
            String pName = null;
            PropertyChangeListenerProxy plistener = null;
            if (listener instanceof PropertyChangeListenerProxy) {
                plistener = (PropertyChangeListenerProxy)listener;
                if (!pNames.contains(plistener.getPropertyName())) continue;
                listener = (PropertyChangeListener)plistener.getListener();
                pName = plistener.getPropertyName();
            }
            if (plistener == null || pName == null || !(listener instanceof DataBindingListener)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("find config listener to remove  [" + pName + "] : " + listener));
            }
            toRemove.add(plistener);
        }
        return toRemove.toArray(new PropertyChangeListener[toRemove.size()]);
    }
}

